/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.datafetcher.helper;

import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLScalarType;
import io.smallrye.graphql.SmallRyeGraphQLServerLogging;
import io.smallrye.graphql.execution.Classes;
import io.smallrye.graphql.execution.datafetcher.helper.AbstractHelper;
import io.smallrye.graphql.json.InputFieldsInfo;
import io.smallrye.graphql.json.JsonBCreator;
import io.smallrye.graphql.scalar.GraphQLScalarTypes;
import io.smallrye.graphql.schema.model.Argument;
import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.ReferenceType;
import io.smallrye.graphql.transformation.AbstractDataFetcherException;
import io.smallrye.graphql.transformation.TransformException;
import io.smallrye.graphql.transformation.Transformer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbException;

public class ArgumentHelper
extends AbstractHelper {
    private final List<Argument> arguments;
    private static final String CONTRUCTOR_METHOD_NAME = "<init>";

    public ArgumentHelper(List<Argument> arguments) {
        this.arguments = arguments;
    }

    public Object[] getArguments(DataFetchingEnvironment dfe) throws AbstractDataFetcherException {
        return this.getArguments(dfe, false);
    }

    public Object[] getArguments(DataFetchingEnvironment dfe, boolean excludeSource) throws AbstractDataFetcherException {
        LinkedList<Object> argumentObjects = new LinkedList<Object>();
        for (Argument argument : this.arguments) {
            if (argument.isSourceArgument() && excludeSource) continue;
            Object argumentValue = this.getArgument(dfe, argument);
            argumentObjects.add(argumentValue);
        }
        return argumentObjects.toArray();
    }

    private Object getArgument(DataFetchingEnvironment dfe, Argument argument) throws AbstractDataFetcherException {
        Object source;
        if (argument.isSourceArgument() && (source = dfe.getSource()) != null) {
            return source;
        }
        Optional<Object> argumentValueFromGraphQLJava = dfe.getArgument(argument.getName());
        if (argumentValueFromGraphQLJava == null) {
            if (argument.hasWrapper() && argument.getWrapper().isOptional()) {
                return Optional.empty();
            }
            return null;
        }
        if (argument.hasWrapper() && argument.getWrapper().isOptional()) {
            argumentValueFromGraphQLJava = Optional.of(argumentValueFromGraphQLJava);
        }
        return super.recursiveTransform(argumentValueFromGraphQLJava, (Field)argument);
    }

    @Override
    Object singleTransform(Object argumentValue, Field field) throws AbstractDataFetcherException {
        if (!Transformer.shouldTransform(field)) {
            return argumentValue;
        }
        return Transformer.in(field, argumentValue);
    }

    @Override
    Object singleMapping(Object argumentValue, Field field) throws AbstractDataFetcherException {
        String methodName;
        if (this.shouldApplyMapping(field) && (methodName = this.getCreateMethodName(field)) != null && !methodName.isEmpty()) {
            Class<?> mappingClass = this.classloadingService.loadClass(field.getReference().getClassName());
            try {
                if (methodName.equals(CONTRUCTOR_METHOD_NAME)) {
                    Constructor<?> constructor = mappingClass.getConstructor(argumentValue.getClass());
                    return constructor.newInstance(argumentValue);
                }
                Method method = mappingClass.getMethod(methodName, argumentValue.getClass());
                if (Modifier.isStatic(method.getModifiers())) {
                    Object instance = method.invoke(null, argumentValue);
                    return instance;
                }
                Constructor<?> constructor = mappingClass.getConstructor(new Class[0]);
                Object instance = constructor.newInstance(new Object[0]);
                method.invoke(instance, argumentValue);
                return instance;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                ex.printStackTrace();
            }
        }
        return argumentValue;
    }

    private boolean shouldApplyMapping(Field field) {
        return field.getReference().hasMapping() && field.getReference().getMapping().getDeserializeMethod() != null || field.hasMapping() && field.getMapping().getDeserializeMethod() != null;
    }

    private String getCreateMethodName(Field field) {
        if (field.getReference().hasMapping()) {
            return field.getReference().getMapping().getDeserializeMethod();
        }
        if (field.hasMapping()) {
            return field.getMapping().getDeserializeMethod();
        }
        return null;
    }

    @Override
    protected Object afterRecursiveTransform(Object fieldValue, Field field) throws AbstractDataFetcherException {
        String receivedType;
        String expectedType = field.getReference().getClassName();
        if (expectedType.equals(receivedType = fieldValue.getClass().getName())) {
            return fieldValue;
        }
        if (Classes.isPrimitiveOf(expectedType, receivedType)) {
            return fieldValue;
        }
        if (field.getReference().getType().equals((Object)ReferenceType.ENUM)) {
            Class<?> enumClass = this.classloadingService.loadClass(field.getReference().getClassName());
            return Enum.valueOf(enumClass, fieldValue.toString());
        }
        return this.correctObjectClass(fieldValue, field);
    }

    private Object correctObjectClass(Object argumentValue, Field field) throws AbstractDataFetcherException {
        String receivedClassName = argumentValue.getClass().getName();
        if (Map.class.isAssignableFrom(argumentValue.getClass())) {
            return this.correctComplexObjectFromMap((Map)argumentValue, field);
        }
        if (receivedClassName.equals(String.class.getName())) {
            return this.correctComplexObjectFromJsonString(argumentValue.toString(), field);
        }
        if (GraphQLScalarTypes.isGraphQLScalarType(field.getReference().getClassName())) {
            GraphQLScalarType scalar = GraphQLScalarTypes.getScalarByClassName(field.getReference().getClassName());
            return scalar.getCoercing().parseLiteral(argumentValue);
        }
        SmallRyeGraphQLServerLogging.log.dontKnowHoToHandleArgument(argumentValue.getClass().getName(), field.getMethodName());
        return argumentValue;
    }

    private Object correctComplexObjectFromMap(Map m, Field field) throws AbstractDataFetcherException {
        String fieldName;
        String className = field.getReference().getClassName();
        if (InputFieldsInfo.hasTransformationFields(className)) {
            Map<String, Field> transformationFields = InputFieldsInfo.getTransformationFields(className);
            for (Map.Entry<String, Field> entry : transformationFields.entrySet()) {
                fieldName = entry.getKey();
                if (!m.containsKey(fieldName)) continue;
                Object valueThatShouldTransform = m.get(fieldName);
                Field fieldThatShouldTransform = entry.getValue();
                valueThatShouldTransform = this.recursiveTransform(valueThatShouldTransform, fieldThatShouldTransform);
                m.put(fieldName, valueThatShouldTransform);
            }
        }
        if (InputFieldsInfo.hasMappingFields(className)) {
            Map<String, Field> mappingFields = InputFieldsInfo.getMappingFields(className);
            for (Map.Entry<String, Field> entry : mappingFields.entrySet()) {
                fieldName = entry.getKey();
                if (!m.containsKey(fieldName)) continue;
                Object valueThatShouldMap = m.get(fieldName);
                Field fieldThatShouldMap = entry.getValue();
                valueThatShouldMap = this.recursiveMapping(valueThatShouldMap, fieldThatShouldMap);
                m.put(fieldName, valueThatShouldMap);
            }
        }
        String jsonString = JsonBCreator.getJsonB().toJson((Object)m);
        return this.correctComplexObjectFromJsonString(jsonString, field);
    }

    private Object correctComplexObjectFromJsonString(String jsonString, Field field) throws AbstractDataFetcherException {
        Class<?> ownerClass = this.classloadingService.loadClass(field.getReference().getClassName());
        try {
            Jsonb jsonb = JsonBCreator.getJsonB(field.getReference().getClassName());
            return jsonb.fromJson(jsonString, ownerClass);
        }
        catch (JsonbException jbe) {
            throw new TransformException(jbe, field, jsonString);
        }
    }
}

