/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.bootstrap;

import graphql.Scalars;
import graphql.schema.DataFetcher;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import graphql.schema.TypeResolver;
import io.smallrye.graphql.bootstrap.Config;
import io.smallrye.graphql.execution.MetricNaming;
import io.smallrye.graphql.execution.datafetcher.PropertyDataFetcher;
import io.smallrye.graphql.execution.datafetcher.ReflectionDataFetcher;
import io.smallrye.graphql.execution.datafetcher.decorator.DataFetcherDecorator;
import io.smallrye.graphql.execution.datafetcher.decorator.MetricDecorator;
import io.smallrye.graphql.execution.datafetcher.decorator.OpenTracingDecorator;
import io.smallrye.graphql.execution.resolver.InterfaceOutputRegistry;
import io.smallrye.graphql.execution.resolver.InterfaceResolver;
import io.smallrye.graphql.json.JsonInputRegistry;
import io.smallrye.graphql.scalar.GraphQLScalarTypes;
import io.smallrye.graphql.schema.model.Argument;
import io.smallrye.graphql.schema.model.Array;
import io.smallrye.graphql.schema.model.EnumType;
import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.InputType;
import io.smallrye.graphql.schema.model.InterfaceType;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.schema.model.OperationType;
import io.smallrye.graphql.schema.model.Reference;
import io.smallrye.graphql.schema.model.ReferenceType;
import io.smallrye.graphql.schema.model.Schema;
import io.smallrye.graphql.schema.model.Type;
import io.smallrye.graphql.spi.ClassloadingService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.json.Json;
import javax.json.JsonReaderFactory;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.jboss.logging.Logger;

public class Bootstrap {
    private static final Logger LOG = Logger.getLogger((String)Bootstrap.class.getName());
    private final Schema schema;
    private final Config config;
    private final GraphQLCodeRegistry.Builder codeRegistryBuilder = GraphQLCodeRegistry.newCodeRegistry();
    private final Map<String, GraphQLEnumType> enumMap = new HashMap<String, GraphQLEnumType>();
    private final Map<String, GraphQLInterfaceType> interfaceMap = new HashMap<String, GraphQLInterfaceType>();
    private final Map<String, GraphQLInputObjectType> inputMap = new HashMap<String, GraphQLInputObjectType>();
    private final Map<String, GraphQLObjectType> typeMap = new HashMap<String, GraphQLObjectType>();
    private static final String QUERY = "Query";
    private static final String MUTATION = "Mutation";
    private static final Jsonb JSONB = JsonbBuilder.create();
    private static final JsonReaderFactory jsonReaderFactory = Json.createReaderFactory(null);

    public static GraphQLSchema bootstrap(Schema schema) {
        return Bootstrap.bootstrap(schema, null);
    }

    public static GraphQLSchema bootstrap(Schema schema, Config config) {
        if (schema != null && (schema.hasQueries() || schema.hasMutations())) {
            Bootstrap graphQLBootstrap = new Bootstrap(schema, config);
            return graphQLBootstrap.generateGraphQLSchema();
        }
        LOG.warn((Object)"Schema is null, or it has no operations. Not bootstrapping SmallRye GraphQL");
        return null;
    }

    public static void registerMetrics(Schema schema, MetricRegistry metricRegistry) {
        Bootstrap.findAllOperations(schema).forEach(operation -> {
            String name = MetricNaming.fromOperation(operation);
            String description = operation.getOperationType() == OperationType.Mutation ? "Call statistics for the mutation '" + operation.getName() + "'" : (operation.getOperationType() == OperationType.Query ? "Call statistics for the query '" + operation.getName() + "'" : "Call statistics for the query '" + operation.getName() + "' on type '" + operation.getContainingType().getName() + "'");
            Metadata metadata = Metadata.builder().withName(name).withType(MetricType.SIMPLE_TIMER).withDescription(description).build();
            metricRegistry.simpleTimer(metadata);
        });
    }

    public static Collection<Operation> findAllOperations(Schema schema) {
        ArrayList<Operation> operations = new ArrayList<Operation>();
        operations.addAll(schema.getQueries());
        operations.addAll(schema.getMutations());
        for (Type value : schema.getTypes().values()) {
            operations.addAll(value.getOperations());
        }
        return operations;
    }

    private Bootstrap(Schema schema, Config config) {
        this.schema = schema;
        this.config = config;
    }

    private GraphQLSchema generateGraphQLSchema() {
        GraphQLSchema.Builder schemaBuilder = GraphQLSchema.newSchema();
        this.createGraphQLEnumTypes();
        this.createGraphQLInterfaceTypes();
        this.createGraphQLObjectTypes();
        this.createGraphQLInputObjectTypes();
        this.addQueries(schemaBuilder);
        this.addMutations(schemaBuilder);
        schemaBuilder.additionalTypes(new HashSet<GraphQLEnumType>(this.enumMap.values()));
        schemaBuilder.additionalTypes(new HashSet<GraphQLInterfaceType>(this.interfaceMap.values()));
        schemaBuilder.additionalTypes(new HashSet<GraphQLObjectType>(this.typeMap.values()));
        schemaBuilder.additionalTypes(new HashSet<GraphQLInputObjectType>(this.inputMap.values()));
        schemaBuilder = schemaBuilder.codeRegistry(this.codeRegistryBuilder.build());
        return schemaBuilder.build();
    }

    private void addQueries(GraphQLSchema.Builder schemaBuilder) {
        GraphQLObjectType.Builder queryBuilder = GraphQLObjectType.newObject().name(QUERY).description("Query root");
        if (this.schema.hasQueries()) {
            Set queries = this.schema.getQueries();
            for (Operation queryOperation : queries) {
                GraphQLFieldDefinition graphQLFieldDefinition = this.createGraphQLFieldDefinitionFromOperation(QUERY, queryOperation);
                queryBuilder = queryBuilder.field(graphQLFieldDefinition);
            }
        }
        GraphQLObjectType query = queryBuilder.build();
        schemaBuilder.query(query);
    }

    private void addMutations(GraphQLSchema.Builder schemaBuilder) {
        if (this.schema.hasMutations()) {
            GraphQLObjectType.Builder mutationBuilder = GraphQLObjectType.newObject().name(MUTATION).description("Mutation root");
            Set mutations = this.schema.getMutations();
            for (Operation mutationOperation : mutations) {
                GraphQLFieldDefinition graphQLFieldDefinition = this.createGraphQLFieldDefinitionFromOperation(MUTATION, mutationOperation);
                mutationBuilder = mutationBuilder.field(graphQLFieldDefinition);
            }
            GraphQLObjectType mutation = mutationBuilder.build();
            if (mutation.getFieldDefinitions() != null && !mutation.getFieldDefinitions().isEmpty()) {
                schemaBuilder.mutation(mutation);
            }
        }
    }

    private void createGraphQLEnumTypes() {
        if (this.schema.hasEnums()) {
            for (EnumType enumType : this.schema.getEnums().values()) {
                this.createGraphQLEnumType(enumType);
            }
        }
    }

    private void createGraphQLEnumType(EnumType enumType) {
        GraphQLEnumType.Builder enumBuilder = GraphQLEnumType.newEnum().name(enumType.getName()).description(enumType.getDescription());
        for (String value : enumType.getValues()) {
            enumBuilder = enumBuilder.value(value);
        }
        GraphQLEnumType graphQLEnumType = enumBuilder.build();
        this.enumMap.put(enumType.getClassName(), graphQLEnumType);
    }

    private void createGraphQLInterfaceTypes() {
        if (this.schema.hasInterfaces()) {
            for (InterfaceType interfaceType : this.schema.getInterfaces().values()) {
                this.createGraphQLInterfaceType(interfaceType);
            }
        }
    }

    private void createGraphQLInterfaceType(InterfaceType interfaceType) {
        GraphQLInterfaceType.Builder interfaceTypeBuilder = GraphQLInterfaceType.newInterface().name(interfaceType.getName()).description(interfaceType.getDescription());
        if (interfaceType.hasFields()) {
            interfaceTypeBuilder = interfaceTypeBuilder.fields(this.createGraphQLFieldDefinitionsFromFields(interfaceType.getName(), interfaceType.getFields()));
        }
        GraphQLInterfaceType graphQLInterfaceType = interfaceTypeBuilder.build();
        this.codeRegistryBuilder.typeResolver(graphQLInterfaceType, (TypeResolver)new InterfaceResolver(interfaceType));
        this.interfaceMap.put(interfaceType.getClassName(), graphQLInterfaceType);
    }

    private void createGraphQLInputObjectTypes() {
        if (this.schema.hasInputs()) {
            for (InputType inputType : this.schema.getInputs().values()) {
                this.createGraphQLInputObjectType(inputType);
            }
        }
    }

    private void createGraphQLInputObjectType(InputType inputType) {
        GraphQLInputObjectType.Builder inputObjectTypeBuilder = GraphQLInputObjectType.newInputObject().name(inputType.getName()).description(inputType.getDescription());
        if (inputType.hasFields()) {
            inputObjectTypeBuilder = inputObjectTypeBuilder.fields(this.createGraphQLInputObjectFieldsFromFields(inputType.getFields()));
            JsonInputRegistry.register(inputType);
        }
        GraphQLInputObjectType graphQLInputObjectType = inputObjectTypeBuilder.build();
        this.inputMap.put(inputType.getClassName(), graphQLInputObjectType);
    }

    private void createGraphQLObjectTypes() {
        if (this.schema.hasTypes()) {
            for (Type type : this.schema.getTypes().values()) {
                this.createGraphQLObjectType(type);
            }
        }
    }

    private void createGraphQLObjectType(Type type) {
        GraphQLObjectType.Builder objectTypeBuilder = GraphQLObjectType.newObject().name(type.getName()).description(type.getDescription());
        if (type.hasFields()) {
            objectTypeBuilder = objectTypeBuilder.fields(this.createGraphQLFieldDefinitionsFromFields(type.getName(), type.getFields()));
        }
        if (type.hasOperations()) {
            for (Operation operation : type.getOperations()) {
                GraphQLFieldDefinition graphQLFieldDefinition = this.createGraphQLFieldDefinitionFromOperation(type.getName(), operation);
                objectTypeBuilder = objectTypeBuilder.field(graphQLFieldDefinition);
            }
        }
        if (type.hasInterfaces()) {
            Set interfaces = type.getInterfaces();
            for (Reference i : interfaces) {
                if (!this.interfaceMap.containsKey(i.getClassName())) continue;
                GraphQLInterfaceType graphQLInterfaceType = this.interfaceMap.get(i.getClassName());
                objectTypeBuilder = objectTypeBuilder.withInterface(graphQLInterfaceType);
            }
        }
        GraphQLObjectType graphQLObjectType = objectTypeBuilder.build();
        this.typeMap.put(type.getClassName(), graphQLObjectType);
        InterfaceOutputRegistry.register(type, graphQLObjectType);
    }

    private GraphQLFieldDefinition createGraphQLFieldDefinitionFromOperation(String operationTypeName, Operation operation) {
        GraphQLFieldDefinition.Builder fieldBuilder = GraphQLFieldDefinition.newFieldDefinition().name(operation.getName()).description(operation.getDescription());
        fieldBuilder = fieldBuilder.type(this.createGraphQLOutputType((Field)operation));
        if (operation.hasArguments()) {
            fieldBuilder = fieldBuilder.arguments(this.createGraphQLArguments(operation.getArguments()));
        }
        GraphQLFieldDefinition graphQLFieldDefinition = fieldBuilder.build();
        ArrayList<DataFetcherDecorator> decorators = new ArrayList<DataFetcherDecorator>();
        if (this.config != null && this.config.isMetricsEnabled()) {
            decorators.add(new MetricDecorator());
        }
        if (this.config != null && this.config.isTracingEnabled()) {
            decorators.add(new OpenTracingDecorator());
        }
        ReflectionDataFetcher datafetcher = new ReflectionDataFetcher(operation, decorators);
        this.codeRegistryBuilder.dataFetcher(FieldCoordinates.coordinates((String)operationTypeName, (String)graphQLFieldDefinition.getName()), (DataFetcher)datafetcher);
        return graphQLFieldDefinition;
    }

    private List<GraphQLFieldDefinition> createGraphQLFieldDefinitionsFromFields(String ownerName, Set<Field> fields) {
        ArrayList<GraphQLFieldDefinition> graphQLFieldDefinitions = new ArrayList<GraphQLFieldDefinition>();
        for (Field field : fields) {
            graphQLFieldDefinitions.add(this.createGraphQLFieldDefinitionFromField(ownerName, field));
        }
        return graphQLFieldDefinitions;
    }

    private GraphQLFieldDefinition createGraphQLFieldDefinitionFromField(String ownerName, Field field) {
        GraphQLFieldDefinition.Builder fieldBuilder = GraphQLFieldDefinition.newFieldDefinition().name(field.getName()).description(field.getDescription());
        fieldBuilder = fieldBuilder.type(this.createGraphQLOutputType(field));
        GraphQLFieldDefinition graphQLFieldDefinition = fieldBuilder.build();
        PropertyDataFetcher datafetcher = new PropertyDataFetcher(field);
        this.codeRegistryBuilder.dataFetcher(FieldCoordinates.coordinates((String)ownerName, (String)graphQLFieldDefinition.getName()), (DataFetcher)datafetcher);
        return graphQLFieldDefinition;
    }

    private List<GraphQLInputObjectField> createGraphQLInputObjectFieldsFromFields(Set<Field> fields) {
        ArrayList<GraphQLInputObjectField> graphQLInputObjectFields = new ArrayList<GraphQLInputObjectField>();
        for (Field field : fields) {
            graphQLInputObjectFields.add(this.createGraphQLInputObjectFieldFromField(field));
        }
        return graphQLInputObjectFields;
    }

    private GraphQLInputObjectField createGraphQLInputObjectFieldFromField(Field field) {
        GraphQLInputObjectField.Builder inputFieldBuilder = GraphQLInputObjectField.newInputObjectField().name(field.getName()).description(field.getDescription());
        inputFieldBuilder = inputFieldBuilder.type(this.createGraphQLInputType(field));
        inputFieldBuilder = inputFieldBuilder.defaultValue(this.sanitizeDefaultValue(field));
        GraphQLInputObjectField graphQLInputObjectField = inputFieldBuilder.build();
        return graphQLInputObjectField;
    }

    private GraphQLInputType createGraphQLInputType(Field field) {
        GraphQLInputType graphQLInputType = this.referenceGraphQLInputType(field);
        if (field.hasArray()) {
            Array array = field.getArray();
            if (array.isNotEmpty()) {
                graphQLInputType = GraphQLNonNull.nonNull((GraphQLType)graphQLInputType);
            }
            for (int i = 0; i < array.getDepth(); ++i) {
                graphQLInputType = GraphQLList.list((GraphQLType)graphQLInputType);
            }
        }
        if (field.isNotNull()) {
            graphQLInputType = GraphQLNonNull.nonNull((GraphQLType)graphQLInputType);
        }
        return graphQLInputType;
    }

    private GraphQLOutputType createGraphQLOutputType(Field field) {
        GraphQLOutputType graphQLOutputType = this.referenceGraphQLOutputType(field);
        if (field.hasArray()) {
            Array array = field.getArray();
            if (array.isNotEmpty()) {
                graphQLOutputType = GraphQLNonNull.nonNull((GraphQLType)graphQLOutputType);
            }
            for (int i = 0; i < array.getDepth(); ++i) {
                graphQLOutputType = GraphQLList.list((GraphQLType)graphQLOutputType);
            }
        }
        if (field.isNotNull()) {
            graphQLOutputType = GraphQLNonNull.nonNull((GraphQLType)graphQLOutputType);
        }
        return graphQLOutputType;
    }

    private GraphQLOutputType referenceGraphQLOutputType(Field field) {
        Reference reference = field.getReference();
        ReferenceType type = reference.getType();
        String className = reference.getClassName();
        String name = reference.getName();
        switch (type) {
            case SCALAR: {
                return this.getCorrectScalarType(field);
            }
            case ENUM: {
                return (GraphQLOutputType)this.enumMap.get(className);
            }
        }
        return GraphQLTypeReference.typeRef((String)name);
    }

    private GraphQLInputType referenceGraphQLInputType(Field field) {
        Reference reference = field.getReference();
        ReferenceType type = reference.getType();
        String className = reference.getClassName();
        String name = reference.getName();
        switch (type) {
            case SCALAR: {
                return this.getCorrectScalarType(field);
            }
            case ENUM: {
                return (GraphQLInputType)this.enumMap.get(className);
            }
        }
        return GraphQLTypeReference.typeRef((String)name);
    }

    private GraphQLScalarType getCorrectScalarType(Field field) {
        if (field.hasTransformInfo()) {
            return Scalars.GraphQLString;
        }
        return GraphQLScalarTypes.getScalarByName(field.getReference().getName());
    }

    private List<GraphQLArgument> createGraphQLArguments(List<Argument> arguments) {
        ArrayList<GraphQLArgument> graphQLArguments = new ArrayList<GraphQLArgument>();
        for (Argument argument : arguments) {
            if (argument.isSourceArgument()) continue;
            graphQLArguments.add(this.createGraphQLArgument(argument));
        }
        return graphQLArguments;
    }

    private GraphQLArgument createGraphQLArgument(Argument argument) {
        GraphQLArgument.Builder argumentBuilder = GraphQLArgument.newArgument().name(argument.getName()).description(argument.getDescription()).defaultValue(this.sanitizeDefaultValue((Field)argument));
        GraphQLInputType graphQLInputType = this.referenceGraphQLInputType((Field)argument);
        if (argument.hasArray()) {
            Array array = argument.getArray();
            if (array.isNotEmpty()) {
                graphQLInputType = GraphQLNonNull.nonNull((GraphQLType)graphQLInputType);
            }
            for (int i = 0; i < array.getDepth(); ++i) {
                graphQLInputType = GraphQLList.list((GraphQLType)graphQLInputType);
            }
        }
        if (argument.isNotNull()) {
            graphQLInputType = GraphQLNonNull.nonNull((GraphQLType)graphQLInputType);
        }
        argumentBuilder = argumentBuilder.type(graphQLInputType);
        GraphQLArgument graphQLArgument = argumentBuilder.build();
        return graphQLArgument;
    }

    private Object sanitizeDefaultValue(Field field) {
        String jsonString = field.getDefaultValue();
        if (this.isJsonString(jsonString)) {
            Class<?> type = ClassloadingService.load().loadClass(field.getReference().getClassName());
            return JSONB.fromJson(jsonString, type);
        }
        return jsonString;
    }

    /*
     * Exception decompiling
     */
    private boolean isJsonString(String string) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

