/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.datafetcher;

import graphql.GraphQLContext;
import graphql.GraphQLError;
import graphql.execution.DataFetcherExceptionHandlerParameters;
import graphql.execution.DataFetcherResult;
import graphql.execution.ExecutionPath;
import graphql.language.SourceLocation;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import io.smallrye.graphql.execution.datafetcher.DataFetcherException;
import io.smallrye.graphql.execution.datafetcher.decorator.DataFetcherDecorator;
import io.smallrye.graphql.execution.datafetcher.helper.ArgumentHelper;
import io.smallrye.graphql.execution.datafetcher.helper.FieldHelper;
import io.smallrye.graphql.execution.error.GraphQLExceptionWhileDataFetching;
import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.spi.ClassloadingService;
import io.smallrye.graphql.spi.LookupService;
import io.smallrye.graphql.transformation.TransformException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.microprofile.graphql.GraphQLException;

public class ReflectionDataFetcher
implements DataFetcher {
    private final LookupService lookupService = LookupService.load();
    private final ClassloadingService classloadingService = ClassloadingService.load();
    private final Operation operation;
    private final FieldHelper fieldHelper;
    private final ArgumentHelper argumentHelper;
    private final Collection<DataFetcherDecorator> decorators;
    private List<Class> parameterClasses;

    public ReflectionDataFetcher(Operation operation) {
        this(operation, Collections.emptyList());
    }

    public ReflectionDataFetcher(Operation operation, Collection<DataFetcherDecorator> decorators) {
        this.operation = operation;
        this.fieldHelper = new FieldHelper((Field)operation);
        this.argumentHelper = new ArgumentHelper(operation.getArguments());
        this.decorators = decorators;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataFetcherResult<Object> get(DataFetchingEnvironment dfe) throws Exception {
        DataFetcherResult.Builder resultBuilder;
        block10: {
            GraphQLContext context = GraphQLContext.newContext().build();
            resultBuilder = DataFetcherResult.newResult().localContext((Object)context);
            this.decorators.forEach(decorator -> decorator.before(dfe));
            Class<?> operationClass = this.classloadingService.loadClass(this.operation.getClassName());
            Object declaringObject = this.lookupService.getInstance(operationClass);
            try {
                Method m = operationClass.getMethod(this.operation.getMethodName(), this.getParameterClasses());
                Object[] transformedArguments = this.argumentHelper.getArguments(dfe);
                Object resultFromMethodCall = m.invoke(declaringObject, transformedArguments);
                resultBuilder.data(this.fieldHelper.transformResponse(resultFromMethodCall));
            }
            catch (TransformException pe) {
                pe.appendDataFetcherResult((DataFetcherResult.Builder<Object>)resultBuilder, dfe);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException | GraphQLException ex) {
                Throwable throwable = ex.getCause();
                if (throwable == null) {
                    throw new DataFetcherException(this.operation, (Exception)ex);
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                if (throwable instanceof GraphQLException) {
                    GraphQLException graphQLException = (GraphQLException)throwable;
                    this.appendPartialResult((DataFetcherResult.Builder<Object>)resultBuilder, dfe, graphQLException);
                    break block10;
                }
                throw (Exception)throwable;
            }
            finally {
                this.decorators.forEach(decorator -> decorator.after(dfe, context));
            }
        }
        return resultBuilder.build();
    }

    private DataFetcherResult.Builder<Object> appendPartialResult(DataFetcherResult.Builder<Object> resultBuilder, DataFetchingEnvironment dfe, GraphQLException graphQLException) {
        DataFetcherExceptionHandlerParameters handlerParameters = DataFetcherExceptionHandlerParameters.newExceptionParameters().dataFetchingEnvironment(dfe).exception((Throwable)graphQLException).build();
        SourceLocation sourceLocation = handlerParameters.getSourceLocation();
        ExecutionPath path = handlerParameters.getPath();
        GraphQLExceptionWhileDataFetching error = new GraphQLExceptionWhileDataFetching(path, graphQLException, sourceLocation);
        return resultBuilder.data(graphQLException.getPartialResults()).error((GraphQLError)error);
    }

    private Class[] getParameterClasses() {
        if (this.operation.hasArguments()) {
            if (this.parameterClasses == null) {
                LinkedList<Class> cl = new LinkedList<Class>();
                for (Field argument : this.operation.getArguments()) {
                    Class<?> clazz;
                    if (argument.hasArray()) {
                        clazz = this.classloadingService.loadClass(argument.getArray().getClassName());
                        cl.add(clazz);
                        continue;
                    }
                    clazz = this.classloadingService.loadClass(argument.getReference().getClassName());
                    cl.add(clazz);
                }
                this.parameterClasses = cl;
            }
            return this.parameterClasses.toArray(new Class[0]);
        }
        return null;
    }
}

