/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.datafetcher.decorator;

import graphql.GraphQLContext;
import graphql.schema.DataFetchingEnvironment;
import io.smallrye.graphql.execution.MetricNaming;
import io.smallrye.graphql.execution.datafetcher.decorator.DataFetcherDecorator;
import io.smallrye.graphql.spi.MetricsService;
import java.time.Duration;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.microprofile.metrics.MetricRegistry;

public class MetricDecorator
implements DataFetcherDecorator {
    private final Map<DataFetchingEnvironment, Long> startTimes = Collections.synchronizedMap(new IdentityHashMap());
    private final MetricRegistry metricRegistry = MetricsService.load().getMetricRegistry(MetricRegistry.Type.VENDOR);

    @Override
    public void before(DataFetchingEnvironment dfe) {
        this.startTimes.put(dfe, System.nanoTime());
    }

    @Override
    public void after(DataFetchingEnvironment dfe, GraphQLContext newGraphQLContext) {
        Long startTime = this.startTimes.remove(dfe);
        if (startTime != null) {
            long duration = System.nanoTime() - startTime;
            String name = MetricNaming.fromTypeAndName(dfe.getParentType(), dfe.getField().getName());
            this.metricRegistry.simpleTimer(name).update(Duration.ofNanos(duration));
        }
    }
}

