/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.datafetcher.decorator;

import graphql.GraphQLContext;
import graphql.schema.DataFetchingEnvironment;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.smallrye.graphql.execution.SpanNaming;
import io.smallrye.graphql.execution.datafetcher.decorator.DataFetcherDecorator;
import io.smallrye.graphql.execution.datafetcher.helper.NameHelper;
import io.smallrye.graphql.spi.OpenTracingService;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;

public class OpenTracingDecorator
implements DataFetcherDecorator {
    private static final Object PARENT_SPAN_KEY = Span.class;
    private final Map<DataFetchingEnvironment, Scope> scopes = Collections.synchronizedMap(new IdentityHashMap());
    OpenTracingService openTracingService = OpenTracingService.load();

    @Override
    public void before(DataFetchingEnvironment env) {
        Tracer tracer = this.openTracingService.getTracer();
        Span parentSpan = this.getParentSpan(tracer, env);
        Scope scope = tracer.buildSpan(SpanNaming.getOperationName(env)).asChildOf(parentSpan).withTag("graphql.executionId", env.getExecutionId().toString()).withTag("graphql.operationName", env.getOperationDefinition().getName()).withTag("graphql.parent", NameHelper.getName(env.getParentType())).withTag("graphql.field", env.getField().getName()).withTag("graphql.path", env.getExecutionStepInfo().getPath().toString()).startActive(true);
        this.scopes.put(env, scope);
    }

    private Span getParentSpan(Tracer tracer, DataFetchingEnvironment env) {
        GraphQLContext localContext = (GraphQLContext)env.getLocalContext();
        if (localContext != null && localContext.hasKey(PARENT_SPAN_KEY)) {
            return (Span)localContext.get(PARENT_SPAN_KEY);
        }
        GraphQLContext rootContext = (GraphQLContext)env.getContext();
        if (rootContext != null && rootContext.hasKey(PARENT_SPAN_KEY)) {
            return (Span)rootContext.get(PARENT_SPAN_KEY);
        }
        return tracer.activeSpan();
    }

    @Override
    public void after(DataFetchingEnvironment env, GraphQLContext newGraphQLContext) {
        Scope scope = this.scopes.remove(env);
        if (scope != null) {
            scope.close();
            newGraphQLContext.put(PARENT_SPAN_KEY, (Object)scope.span());
        }
    }
}

