/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.datafetcher.helper;

import graphql.schema.DataFetchingEnvironment;
import io.smallrye.graphql.execution.Classes;
import io.smallrye.graphql.execution.datafetcher.helper.AbstractHelper;
import io.smallrye.graphql.json.InputTransformFields;
import io.smallrye.graphql.json.JsonBCreator;
import io.smallrye.graphql.schema.model.Argument;
import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.transformation.TransformException;
import io.smallrye.graphql.transformation.Transformer;
import java.text.ParseException;
import java.time.DateTimeException;
import java.util.List;
import java.util.Map;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbException;
import org.eclipse.microprofile.graphql.GraphQLException;
import org.jboss.logging.Logger;

public class ArgumentHelper
extends AbstractHelper {
    private static final Logger LOG = Logger.getLogger((String)ArgumentHelper.class.getName());
    private final List<Argument> arguments;

    public ArgumentHelper(List<Argument> arguments) {
        this.arguments = arguments;
    }

    public Object[] getArguments(DataFetchingEnvironment dfe) throws GraphQLException, DateTimeException, ParseException, NumberFormatException {
        Object[] argumentObjects = new Object[this.arguments.size()];
        int idx = 0;
        for (Argument argument : this.arguments) {
            Object argumentValue;
            argumentObjects[idx] = argumentValue = this.getArgument(dfe, argument);
            ++idx;
        }
        return argumentObjects;
    }

    private Object getArgument(DataFetchingEnvironment dfe, Argument argument) throws GraphQLException, DateTimeException, ParseException, NumberFormatException {
        Object source;
        if (argument.isSourceArgument() && (source = dfe.getSource()) != null) {
            return source;
        }
        Object argumentValueFromGraphQLJava = dfe.getArgument(argument.getName());
        if (argumentValueFromGraphQLJava == null) {
            return null;
        }
        return super.recursiveTransform(argumentValueFromGraphQLJava, (Field)argument);
    }

    @Override
    Object singleTransform(Object argumentValue, Field field) {
        try {
            Transformer transformer = Transformer.transformer(field);
            return transformer.in(argumentValue);
        }
        catch (Exception e) {
            LOG.error(null, (Throwable)e);
            throw new TransformException(e, field, argumentValue);
        }
    }

    @Override
    protected Object afterRecursiveTransform(Object fieldValue, Field field) throws GraphQLException {
        String receivedType;
        String expectedType = field.getReference().getClassName();
        if (expectedType.equals(receivedType = fieldValue.getClass().getName())) {
            return fieldValue;
        }
        if (Classes.isPrimitiveOf(expectedType, receivedType)) {
            return fieldValue;
        }
        return this.correctObjectClass(fieldValue, field);
    }

    private Object correctObjectClass(Object argumentValue, Field field) throws GraphQLException {
        String receivedClassName = argumentValue.getClass().getName();
        if (Map.class.isAssignableFrom(argumentValue.getClass())) {
            return this.correctComplexObjectFromMap((Map)argumentValue, field);
        }
        if (receivedClassName.equals(String.class.getName())) {
            return this.correctComplexObjectFromJsonString(argumentValue.toString(), field);
        }
        LOG.warn((Object)("Returning argument as is, because we did not know how to handle it.\n\t[" + field.getMethodName() + "]"));
        return argumentValue;
    }

    private Object correctComplexObjectFromMap(Map m, Field field) throws GraphQLException {
        String className = field.getReference().getClassName();
        if (InputTransformFields.hasTransformationFields(className)) {
            Map<String, Field> transformationFields = InputTransformFields.getTransformationFields(className);
            for (Map.Entry<String, Field> entry : transformationFields.entrySet()) {
                String fieldName = entry.getKey();
                if (!m.containsKey(fieldName)) continue;
                Object valueThatShouldTransform = m.get(fieldName);
                Field fieldThatShouldTransform = entry.getValue();
                valueThatShouldTransform = this.recursiveTransform(valueThatShouldTransform, fieldThatShouldTransform);
                m.put(fieldName, valueThatShouldTransform);
            }
        }
        String jsonString = JsonBCreator.getJsonB().toJson((Object)m);
        return this.correctComplexObjectFromJsonString(jsonString, field);
    }

    private Object correctComplexObjectFromJsonString(String jsonString, Field field) {
        Class<?> ownerClass = this.classloadingService.loadClass(field.getReference().getClassName());
        try {
            Jsonb jsonb = JsonBCreator.getJsonB(field.getReference().getClassName());
            return jsonb.fromJson(jsonString, ownerClass);
        }
        catch (JsonbException jbe) {
            throw new TransformException(jbe, field, jsonString);
        }
    }
}

