/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.json;

import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.InputType;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class InputTransformFields {
    private static final Map<String, Map<String, Field>> inputFieldMap = new HashMap<String, Map<String, Field>>();

    private InputTransformFields() {
    }

    protected static void register(InputType inputType) {
        if (inputType.hasFields()) {
            HashMap<String, Field> fieldsThatNeedsTransformation = new HashMap<String, Field>();
            Set fields = inputType.getFields();
            for (Field field : fields) {
                if (!field.hasTransformInfo() || field.getTransformInfo().isJsonB()) continue;
                fieldsThatNeedsTransformation.put(field.getName(), field);
            }
            if (!fieldsThatNeedsTransformation.isEmpty()) {
                inputFieldMap.put(inputType.getClassName(), fieldsThatNeedsTransformation);
            }
        }
    }

    public static boolean hasTransformationFields(String className) {
        return inputFieldMap.containsKey(className);
    }

    public static Map<String, Field> getTransformationFields(String className) {
        if (inputFieldMap.containsKey(className)) {
            return inputFieldMap.get(className);
        }
        return null;
    }
}

