/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.scalar.number;

import graphql.Scalars;
import io.smallrye.graphql.execution.Classes;
import io.smallrye.graphql.scalar.number.AbstractNumberScalar;
import io.smallrye.graphql.scalar.number.Converter;
import io.smallrye.graphql.schema.model.Argument;
import java.math.BigDecimal;
import java.math.BigInteger;

public class FloatScalar
extends AbstractNumberScalar {
    public FloatScalar() {
        super(Scalars.GraphQLFloat.getName(), new Converter(){

            @Override
            public Object fromBigDecimal(BigDecimal bigDecimal) {
                return Float.valueOf(bigDecimal.floatValue());
            }

            @Override
            public Object fromBigInteger(BigInteger bigInteger) {
                return Float.valueOf(bigInteger.floatValue());
            }

            @Override
            public Object fromNumber(Number number, Argument argument) {
                String argumentName = argument.getReference().getClassName();
                if (argumentName.equals(Classes.FLOAT) || argumentName.equals(Classes.FLOAT_PRIMATIVE)) {
                    return Float.valueOf(number.floatValue());
                }
                return number.doubleValue();
            }
        }, Float.class, Float.TYPE, Double.class, Double.TYPE);
    }
}

