/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.scalar.number;

import graphql.language.FloatValue;
import graphql.language.IntValue;
import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import io.smallrye.graphql.scalar.number.Converter;
import java.math.BigDecimal;
import java.math.BigInteger;

public class NumberCoercing
implements Coercing {
    private final Class[] supportedTypes;
    private final Converter converter;
    private final String name;

    public NumberCoercing(String name, Converter converter, Class ... supportedTypes) {
        this.name = name;
        this.converter = converter;
        this.supportedTypes = supportedTypes;
    }

    private Object convertImpl(Object input) {
        for (Class supportedClass : this.supportedTypes) {
            if (!supportedClass.isInstance(input)) continue;
            return supportedClass.cast(input);
        }
        if (input instanceof Number) {
            BigDecimal value = new BigDecimal(input.toString());
            return this.converter.fromBigDecimal(value);
        }
        if (input instanceof String) {
            return input;
        }
        throw new NumberFormatException("" + input);
    }

    public Object serialize(Object input) {
        if (input == null) {
            return null;
        }
        try {
            return this.convertImpl(input);
        }
        catch (NumberFormatException e) {
            throw new CoercingSerializeException("Expected type '" + this.name + "' but was '" + input.getClass().getSimpleName() + "'.", (Throwable)e);
        }
    }

    public Object parseValue(Object input) {
        try {
            return this.convertImpl(input);
        }
        catch (NumberFormatException e) {
            throw new CoercingParseValueException("Expected type '" + this.name + "' but was '" + input.getClass().getSimpleName() + "'.");
        }
    }

    public Object parseLiteral(Object input) {
        if (input == null) {
            return null;
        }
        if (input instanceof StringValue) {
            try {
                BigDecimal value = new BigDecimal(((StringValue)input).getValue());
                return this.converter.fromBigDecimal(value);
            }
            catch (NumberFormatException e) {
                return ((StringValue)input).getValue();
            }
        }
        if (input instanceof IntValue) {
            BigInteger value = ((IntValue)input).getValue();
            if (!this.converter.isInRange(value)) {
                throw new CoercingParseLiteralException("Expected value to be in the " + this.name + " range but it was '" + value.toString() + "'");
            }
            return this.converter.fromBigInteger(value);
        }
        if (input instanceof FloatValue) {
            BigDecimal value = ((FloatValue)input).getValue();
            return this.converter.fromBigDecimal(value);
        }
        throw new CoercingParseLiteralException("Expected AST type 'IntValue' or 'StringValue' but was '" + input.getClass().getSimpleName() + "'.");
    }
}

