/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.spi;

import io.opentracing.Tracer;
import java.util.ServiceLoader;
import org.jboss.logging.Logger;

public interface OpenTracingService {
    public static final Logger LOG = Logger.getLogger((String)OpenTracingService.class.getName());

    public static OpenTracingService load() {
        OpenTracingService openTracingService;
        try {
            ServiceLoader<OpenTracingService> sl = ServiceLoader.load(OpenTracingService.class);
            openTracingService = sl.iterator().next();
        }
        catch (Exception ex) {
            openTracingService = new DefaultOpenTracingService();
        }
        LOG.debug((Object)("Using " + openTracingService.getName() + " lookup service"));
        return openTracingService;
    }

    public String getName();

    public Tracer getTracer();

    public static class DefaultOpenTracingService
    implements OpenTracingService {
        @Override
        public String getName() {
            return "Unsupported OpenTracing Service";
        }

        @Override
        public Tracer getTracer() {
            throw new UnsupportedOperationException("OpenTracing is not supported without CDI");
        }
    }
}

