/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.transformation;

import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.transformation.DateTransformer;
import io.smallrye.graphql.transformation.Transformer;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class LegacyDateTransformer
implements Transformer {
    private static final Map<String, String> CLASS_MAPPINGS = LegacyDateTransformer.createClassMappings();
    public static final Set<String> SUPPORTED_TYPES = Collections.unmodifiableSet(CLASS_MAPPINGS.keySet());
    private final DateTransformer dateTransformer;
    private final String targetClassName;

    public LegacyDateTransformer(Field field) {
        this.targetClassName = field.getReference().getClassName();
        this.dateTransformer = new DateTransformer(field, CLASS_MAPPINGS.get(this.targetClassName));
    }

    @Override
    public Object in(Object o) throws Exception {
        if (this.targetClassName.equals(java.sql.Date.class.getName())) {
            LocalDate localdate = (LocalDate)this.dateTransformer.in(o);
            return java.sql.Date.valueOf(localdate);
        }
        if (this.targetClassName.equals(Time.class.getName())) {
            LocalTime localtime = (LocalTime)this.dateTransformer.in(o);
            return Time.valueOf(localtime);
        }
        if (this.targetClassName.equals(Timestamp.class.getName())) {
            LocalDateTime localdatetime = (LocalDateTime)this.dateTransformer.in(o);
            return Timestamp.valueOf(localdatetime);
        }
        if (this.targetClassName.equals(Date.class.getName())) {
            LocalDateTime localdatetime = (LocalDateTime)this.dateTransformer.in(o);
            return Date.from(localdatetime.atZone(ZoneId.systemDefault()).toInstant());
        }
        throw new RuntimeException("Can't parse [" + o.getClass().getName() + "] to [" + this.targetClassName + "]");
    }

    @Override
    public Object out(Object dateType) {
        if (dateType instanceof java.sql.Date) {
            java.sql.Date casted = (java.sql.Date)dateType;
            return this.dateTransformer.out(casted.toLocalDate());
        }
        if (dateType instanceof Time) {
            Time casted = (Time)dateType;
            return this.dateTransformer.out(casted.toLocalTime());
        }
        if (dateType instanceof Timestamp) {
            Timestamp casted = (Timestamp)dateType;
            return this.dateTransformer.out(casted.toLocalDateTime());
        }
        if (dateType instanceof Date) {
            Date casted = (Date)dateType;
            return this.dateTransformer.out(casted.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime());
        }
        throw new RuntimeException("Can't format [" + dateType.getClass().getName() + "] from [" + this.targetClassName + "]");
    }

    private static Map<String, String> createClassMappings() {
        HashMap<String, String> stringStringHashMap = new HashMap<String, String>();
        stringStringHashMap.put(java.sql.Date.class.getName(), LocalDate.class.getName());
        stringStringHashMap.put(Time.class.getName(), LocalTime.class.getName());
        stringStringHashMap.put(Timestamp.class.getName(), LocalDateTime.class.getName());
        stringStringHashMap.put(Date.class.getName(), LocalDateTime.class.getName());
        return stringStringHashMap;
    }
}

