/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.transformation;

import graphql.GraphQLError;
import graphql.execution.DataFetcherExceptionHandlerParameters;
import graphql.execution.DataFetcherResult;
import graphql.execution.ExecutionPath;
import graphql.language.Argument;
import graphql.language.SourceLocation;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLScalarType;
import graphql.validation.ValidationError;
import graphql.validation.ValidationErrorType;
import io.smallrye.graphql.scalar.GraphQLScalarTypes;
import io.smallrye.graphql.schema.model.Field;
import java.util.ArrayList;
import java.util.List;

public class TransformException
extends RuntimeException {
    private final Field field;
    private final String parameterValue;

    public TransformException(Throwable original, Field field, Object parameterValue) {
        super(original);
        this.field = field;
        this.parameterValue = parameterValue != null ? parameterValue.toString() : null;
    }

    public DataFetcherResult.Builder<Object> appendDataFetcherResult(DataFetcherResult.Builder<Object> builder, DataFetchingEnvironment dfe) {
        DataFetcherExceptionHandlerParameters handlerParameters = DataFetcherExceptionHandlerParameters.newExceptionParameters().dataFetchingEnvironment(dfe).exception(super.getCause()).build();
        SourceLocation sourceLocation = this.getSourceLocation(dfe, handlerParameters);
        List<String> paths = this.toPathList(handlerParameters.getPath());
        ValidationError error = new ValidationError(ValidationErrorType.WrongType, sourceLocation, "argument '" + this.field.getName() + "' with value 'StringValue{value='" + this.parameterValue + "'}' is not a valid '" + this.getScalarTypeName() + "'", paths);
        return builder.error((GraphQLError)error);
    }

    private String getScalarTypeName() {
        GraphQLScalarType graphQLScalarType = GraphQLScalarTypes.getScalarMap().get(this.field.getReference().getClassName());
        if (graphQLScalarType != null) {
            return graphQLScalarType.getName();
        }
        return "Unknown Scalar Type [" + this.field.getReference().getClassName() + "]";
    }

    private SourceLocation getSourceLocation(DataFetchingEnvironment dfe, DataFetcherExceptionHandlerParameters handlerParameters) {
        List arguments = dfe.getField().getArguments();
        for (Argument a : arguments) {
            if (!a.getName().equals(this.field.getName())) continue;
            return a.getSourceLocation();
        }
        return handlerParameters.getSourceLocation();
    }

    private List<String> toPathList(ExecutionPath path) {
        ArrayList<String> l = new ArrayList<String>();
        for (Object o : path.toList()) {
            l.add(o.toString());
        }
        return l;
    }
}

