/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution;

import io.smallrye.graphql.SmallRyeGraphQLServerLogging;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;

public class GraphQLVariables {
    private static final String VARIABLES = "variables";

    public Optional<Map<String, Object>> getVariables(JsonObject jsonInput) {
        if (!jsonInput.containsKey((Object)VARIABLES) || jsonInput.get((Object)VARIABLES) == null || ((JsonValue)jsonInput.get((Object)VARIABLES)).getValueType().equals((Object)JsonValue.ValueType.NULL)) {
            return Optional.empty();
        }
        JsonValue.ValueType valueType = ((JsonValue)jsonInput.get((Object)VARIABLES)).getValueType();
        if (valueType.equals((Object)JsonValue.ValueType.STRING)) {
            String stringVars = jsonInput.getString(VARIABLES);
            SmallRyeGraphQLServerLogging.log.stringInputForVariables(stringVars);
            return Optional.empty();
        }
        JsonValue jvariables = (JsonValue)jsonInput.get((Object)VARIABLES);
        return this.getVariables(jvariables);
    }

    private Optional<Map<String, Object>> getVariables(JsonValue jsonValue) {
        if (!(null == jsonValue || JsonValue.NULL.equals(jsonValue) || JsonValue.EMPTY_JSON_OBJECT.equals(jsonValue) || JsonValue.EMPTY_JSON_ARRAY.equals(jsonValue))) {
            return Optional.of(this.toMap(jsonValue.asJsonObject()));
        }
        return Optional.empty();
    }

    private Map<String, Object> toMap(JsonObject jo) {
        HashMap<String, Object> ro = new HashMap<String, Object>();
        if (jo != null) {
            Set entrySet = jo.entrySet();
            for (Map.Entry es : entrySet) {
                ro.put((String)es.getKey(), this.toObject((JsonValue)es.getValue()));
            }
        }
        return ro;
    }

    private Object toObject(JsonValue jsonValue) {
        Object ret = null;
        JsonValue.ValueType typ = jsonValue.getValueType();
        if (null != typ) {
            switch (typ) {
                case NUMBER: {
                    ret = ((JsonNumber)jsonValue).bigDecimalValue();
                    break;
                }
                case STRING: {
                    ret = ((JsonString)jsonValue).getString();
                    break;
                }
                case FALSE: {
                    ret = Boolean.FALSE;
                    break;
                }
                case TRUE: {
                    ret = Boolean.TRUE;
                    break;
                }
                case ARRAY: {
                    JsonArray arr = (JsonArray)jsonValue;
                    ArrayList<Object> vals = new ArrayList<Object>();
                    int sz = arr.size();
                    for (int i = 0; i < sz; ++i) {
                        JsonValue v = (JsonValue)arr.get(i);
                        vals.add(this.toObject(v));
                    }
                    ret = vals;
                    break;
                }
                case OBJECT: {
                    ret = this.toMap((JsonObject)jsonValue);
                    break;
                }
            }
        }
        return ret;
    }
}

