/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.datafetcher;

import graphql.GraphQLError;
import graphql.execution.DataFetcherExceptionHandlerParameters;
import graphql.execution.DataFetcherResult;
import graphql.execution.ExecutionPath;
import graphql.language.SourceLocation;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import io.smallrye.graphql.SmallRyeGraphQLServerMessages;
import io.smallrye.graphql.execution.datafetcher.ExecutionContext;
import io.smallrye.graphql.execution.datafetcher.decorator.DataFetcherDecorator;
import io.smallrye.graphql.execution.datafetcher.helper.ArgumentHelper;
import io.smallrye.graphql.execution.datafetcher.helper.FieldHelper;
import io.smallrye.graphql.execution.error.GraphQLExceptionWhileDataFetching;
import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.spi.ClassloadingService;
import io.smallrye.graphql.spi.LookupService;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.microprofile.graphql.GraphQLException;

public abstract class AbstractDataFetcher<T>
implements DataFetcher<T> {
    protected final LookupService lookupService = LookupService.load();
    protected final ClassloadingService classloadingService = ClassloadingService.load();
    protected final Operation operation;
    protected final FieldHelper fieldHelper;
    protected final ArgumentHelper argumentHelper;
    protected final Collection<DataFetcherDecorator> decorators;
    protected List<Class<?>> parameterClasses;

    protected AbstractDataFetcher(Operation operation, Collection<DataFetcherDecorator> decorators) {
        this.operation = operation;
        this.fieldHelper = new FieldHelper((Field)operation);
        this.argumentHelper = new ArgumentHelper(operation.getArguments());
        this.decorators = decorators;
    }

    public abstract T get(DataFetchingEnvironment var1) throws Exception;

    protected final DataFetcherResult.Builder<Object> appendPartialResult(DataFetcherResult.Builder<Object> resultBuilder, DataFetchingEnvironment dfe, GraphQLException graphQLException) {
        DataFetcherExceptionHandlerParameters handlerParameters = DataFetcherExceptionHandlerParameters.newExceptionParameters().dataFetchingEnvironment(dfe).exception((Throwable)graphQLException).build();
        SourceLocation sourceLocation = handlerParameters.getSourceLocation();
        ExecutionPath path = handlerParameters.getPath();
        GraphQLExceptionWhileDataFetching error = new GraphQLExceptionWhileDataFetching(path, graphQLException, sourceLocation);
        return resultBuilder.data(graphQLException.getPartialResults()).error((GraphQLError)error);
    }

    protected final Class<?>[] getParameterClasses() {
        if (this.operation.hasArguments()) {
            if (this.parameterClasses == null) {
                LinkedList cl = new LinkedList();
                for (Field argument : this.operation.getArguments()) {
                    Class<?> clazz;
                    if (argument.hasArray()) {
                        clazz = this.classloadingService.loadClass(argument.getArray().getClassName());
                        cl.add(clazz);
                        continue;
                    }
                    clazz = this.classloadingService.loadClass(argument.getReference().getClassName());
                    cl.add(clazz);
                }
                this.parameterClasses = cl;
            }
            return this.parameterClasses.toArray(new Class[0]);
        }
        return null;
    }

    protected final Method getMethod(Class<?> operationClass) {
        try {
            return operationClass.getMethod(this.operation.getMethodName(), this.getParameterClasses());
        }
        catch (NoSuchMethodException e) {
            throw SmallRyeGraphQLServerMessages.msg.dataFetcherException(this.operation, e);
        }
    }

    protected final <R> R execute(ExecutionContext executionContext) throws Exception {
        try {
            return (R)executionContext.proceed();
        }
        catch (InvocationTargetException ex) {
            Throwable throwable = ex.getCause();
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof GraphQLException) {
                throw (GraphQLException)throwable;
            }
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            throw SmallRyeGraphQLServerMessages.msg.dataFetcherException(this.operation, throwable);
        }
    }
}

