/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.datafetcher.decorator;

import graphql.ErrorClassification;
import graphql.ErrorType;
import graphql.GraphQLError;
import graphql.execution.DataFetcherResult;
import graphql.language.Argument;
import graphql.language.Field;
import graphql.language.NamedNode;
import graphql.language.Node;
import graphql.language.SourceLocation;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLArgument;
import io.smallrye.graphql.execution.datafetcher.ExecutionContext;
import io.smallrye.graphql.execution.datafetcher.decorator.AbstractDataFetcherDecorator;
import io.smallrye.graphql.transformation.AbstractDataFetcherException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.validation.ConstraintViolation;
import javax.validation.Path;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;

public class ValidationDecorator
extends AbstractDataFetcherDecorator {
    private static final ValidatorFactory VALIDATOR_FACTORY = Validation.buildDefaultValidatorFactory();

    @Override
    protected void before(ExecutionContext executionContext) throws BeanValidationException {
        Set violations = VALIDATOR_FACTORY.getValidator().forExecutables().validateParameters(executionContext.target(), executionContext.method(), executionContext.arguments(), new Class[0]);
        if (!violations.isEmpty()) {
            throw new BeanValidationException(violations, executionContext.method());
        }
    }

    static <T> Stream<T> toStream(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    private static class ValidationFailedGraphQLError
    implements GraphQLError {
        private final ConstraintViolation<Object> violation;
        private final List<NamedNode<?>> requestedPath;

        public ValidationFailedGraphQLError(ConstraintViolation<Object> violation, List<NamedNode<?>> requestedPath) {
            this.violation = violation;
            this.requestedPath = requestedPath;
        }

        public ErrorClassification getErrorType() {
            return ErrorType.ValidationError;
        }

        public String getMessage() {
            return "validation failed: " + this.violation.getPropertyPath() + " " + this.violation.getMessage();
        }

        public List<SourceLocation> getLocations() {
            return this.requestedPath.stream().map(Node::getSourceLocation).collect(Collectors.toList());
        }

        public List<Object> getPath() {
            return this.requestedPath.stream().map(argument -> argument.getName()).collect(Collectors.toList());
        }

        public Map<String, Object> getExtensions() {
            HashMap<String, Object> extensions = new HashMap<String, Object>();
            extensions.put("violation.message", this.violation.getMessage());
            extensions.put("violation.propertyPath", ValidationDecorator.toStream(this.violation.getPropertyPath()).flatMap(this::items).collect(Collectors.toList()));
            extensions.put("violation.invalidValue", this.violation.getInvalidValue());
            extensions.put("violation.constraint", this.getConstraintAttributes());
            return extensions;
        }

        private Stream<String> items(Path.Node node) {
            if (node.getIndex() == null) {
                return Stream.of(node.getName());
            }
            return Stream.of(node.getIndex().toString(), node.getName());
        }

        private Map<String, Object> getConstraintAttributes() {
            HashMap<String, Object> attributes = new HashMap<String, Object>(this.violation.getConstraintDescriptor().getAttributes());
            attributes.computeIfPresent("groups", ValidationFailedGraphQLError::classNames);
            attributes.computeIfPresent("payload", ValidationFailedGraphQLError::classNames);
            return attributes;
        }

        private static Object classNames(String key, Object oldValue) {
            return Stream.of((Class[])oldValue).map(Class::getName).collect(Collectors.toList());
        }
    }

    private static class BeanValidationException
    extends AbstractDataFetcherException {
        private final Set<ConstraintViolation<Object>> violations;
        private final Method method;

        public BeanValidationException(Set<ConstraintViolation<Object>> violations, Method method) {
            this.violations = violations;
            this.method = method;
        }

        @Override
        public DataFetcherResult.Builder<Object> appendDataFetcherResult(DataFetcherResult.Builder<Object> builder, DataFetchingEnvironment dfe) {
            RequestNodeBuilder requestNodeBuilder = new RequestNodeBuilder(this.method, dfe);
            this.violations.stream().map(violation -> new ValidationFailedGraphQLError((ConstraintViolation<Object>)violation, requestNodeBuilder.build((ConstraintViolation<Object>)violation))).forEach(arg_0 -> builder.error(arg_0));
            return builder;
        }

        private static class RequestNodeBuilder {
            private final Method method;
            private final DataFetchingEnvironment dfe;

            RequestNodeBuilder(Method method, DataFetchingEnvironment dfe) {
                this.method = method;
                this.dfe = dfe;
            }

            List<NamedNode<?>> build(ConstraintViolation<Object> violation) {
                Iterator violationNodes = violation.getPropertyPath().iterator();
                return Arrays.asList(this.methodNode((Path.Node)violationNodes.next()), this.requestedArgument((Path.Node)violationNodes.next()));
            }

            private Field methodNode(Path.Node methodNode) {
                assert (this.dfe.getFieldDefinition().getName().equals(methodNode.getName())) : "expected first violation path item " + methodNode.getName() + " to be the method name field definition " + this.dfe.getFieldDefinition().getName();
                return this.dfe.getField();
            }

            private Argument requestedArgument(Path.Node node) {
                String graphQLArgumentName = ((GraphQLArgument)this.dfe.getFieldDefinition().getArguments().get(this.parameterIndex(node.getName()))).getName();
                Field requestedField = this.dfe.getMergedField().getSingleField();
                return requestedField.getArguments().stream().filter(argument -> argument.getName().equals(graphQLArgumentName)).findFirst().orElseThrow(() -> new AssertionError((Object)("expected field " + graphQLArgumentName + " in " + requestedField.getArguments())));
            }

            private int parameterIndex(String name) {
                Parameter[] parameters = this.method.getParameters();
                for (int i = 0; i < parameters.length; ++i) {
                    if (!name.equals(parameters[i].getName())) continue;
                    return i;
                }
                throw new AssertionError((Object)("expected parameter " + name + " in " + this.method));
            }
        }
    }
}

