/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.spi;

import io.smallrye.graphql.SmallRyeGraphQLServerLogging;
import io.smallrye.graphql.SmallRyeGraphQLServerMessages;
import java.util.ServiceLoader;
import org.eclipse.microprofile.metrics.MetricRegistry;

public interface MetricsService {
    public static MetricsService load() {
        MetricsService metricsService;
        try {
            ServiceLoader<MetricsService> sl = ServiceLoader.load(MetricsService.class);
            metricsService = sl.iterator().next();
        }
        catch (Exception ex) {
            metricsService = new DefaultMetricsService();
        }
        SmallRyeGraphQLServerLogging.log.usingMetricsService(metricsService.getName());
        return metricsService;
    }

    public String getName();

    public MetricRegistry getMetricRegistry(MetricRegistry.Type var1);

    public static class DefaultMetricsService
    implements MetricsService {
        @Override
        public String getName() {
            return "Unsupported Metrics Service";
        }

        @Override
        public MetricRegistry getMetricRegistry(MetricRegistry.Type type) {
            throw SmallRyeGraphQLServerMessages.msg.metricsNotSupportedWithoutCDI();
        }
    }
}

