/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.spi;

import io.opentracing.Tracer;
import io.smallrye.graphql.SmallRyeGraphQLServerLogging;
import io.smallrye.graphql.SmallRyeGraphQLServerMessages;
import java.util.ServiceLoader;

public interface OpenTracingService {
    public static OpenTracingService load() {
        OpenTracingService openTracingService;
        try {
            ServiceLoader<OpenTracingService> sl = ServiceLoader.load(OpenTracingService.class);
            openTracingService = sl.iterator().next();
        }
        catch (Exception ex) {
            openTracingService = new DefaultOpenTracingService();
        }
        SmallRyeGraphQLServerLogging.log.usingTracingService(openTracingService.getName());
        return openTracingService;
    }

    public String getName();

    public Tracer getTracer();

    public static class DefaultOpenTracingService
    implements OpenTracingService {
        @Override
        public String getName() {
            return "Unsupported OpenTracing Service";
        }

        @Override
        public Tracer getTracer() {
            throw SmallRyeGraphQLServerMessages.msg.openTracingNotSupportedWithoutCDI();
        }
    }
}

