/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.context;

import graphql.schema.DataFetchingEnvironment;
import graphql.schema.DataFetchingFieldSelectionSet;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLType;
import graphql.schema.SelectedField;
import io.smallrye.graphql.SmallRyeGraphQLServerMessages;
import io.smallrye.graphql.api.Context;
import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.ReferenceType;
import io.smallrye.graphql.schema.model.Schema;
import io.smallrye.graphql.schema.model.Type;
import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;

public class SmallRyeContext
implements Context {
    private static Schema schema;
    private static final ThreadLocal<SmallRyeContext> current;
    private final JsonObject jsonObject;
    private DataFetchingEnvironment dfe;
    private Field field;
    private final JsonBuilderFactory jsonbuilder = Json.createBuilderFactory(null);

    public static void register(JsonObject jsonInput) {
        SmallRyeContext registry = new SmallRyeContext(jsonInput);
        current.set(registry);
    }

    public static void setSchema(Schema schema) {
        SmallRyeContext.schema = schema;
    }

    public static Context getContext() {
        return current.get();
    }

    public static void remove() {
        current.remove();
    }

    public JsonObject getRequest() {
        return this.jsonObject;
    }

    public <T> T unwrap(Class<T> wrappedType) {
        if (wrappedType.equals(DataFetchingEnvironment.class)) {
            return (T)this.dfe;
        }
        throw SmallRyeGraphQLServerMessages.msg.unsupportedWrappedClass(wrappedType.getName());
    }

    public boolean hasArgument(String name) {
        return this.dfe.containsArgument(name);
    }

    public <T> T getArgument(String name) {
        return (T)this.dfe.getArgument(name);
    }

    public Map<String, Object> getArguments() {
        return this.dfe.getArguments();
    }

    public String getPath() {
        return this.dfe.getExecutionStepInfo().getPath().toString();
    }

    public String getExecutionId() {
        return this.dfe.getExecutionId().toString();
    }

    public String getFieldName() {
        return this.dfe.getField().getName();
    }

    public <T> T getSource() {
        return (T)this.dfe.getSource();
    }

    public JsonArray getSelectedFields(boolean includeSourceFields) {
        DataFetchingFieldSelectionSet selectionSet = this.dfe.getSelectionSet();
        List fields = selectionSet.getFields();
        return this.toJsonArrayBuilder(fields, includeSourceFields).build();
    }

    private SmallRyeContext(JsonObject jsonObject) {
        this.jsonObject = jsonObject;
    }

    public void setDataFromFetcher(DataFetchingEnvironment dfe, Field field) {
        this.dfe = dfe;
        this.field = field;
    }

    private JsonArrayBuilder toJsonArrayBuilder(List<SelectedField> fields, boolean includeSourceFields) {
        JsonArrayBuilder builder = this.jsonbuilder.createArrayBuilder();
        for (SelectedField field : fields) {
            if (this.isFlattenScalar(field) || !includeSourceFields && this.isSourceField(field)) continue;
            if (this.isScalar(field)) {
                builder = builder.add(field.getName());
                continue;
            }
            builder = builder.add(this.toJsonObjectBuilder(field, includeSourceFields));
        }
        return builder;
    }

    private JsonObjectBuilder toJsonObjectBuilder(SelectedField selectedField, boolean includeSourceFields) {
        JsonObjectBuilder builder = this.jsonbuilder.createObjectBuilder();
        builder = builder.add(selectedField.getName(), this.toJsonArrayBuilder(selectedField.getSelectionSet().getFields(), includeSourceFields));
        return builder;
    }

    private boolean isSourceField(SelectedField selectedField) {
        if (this.field.getReference().getType().equals((Object)ReferenceType.TYPE)) {
            Type type = (Type)schema.getTypes().get(this.field.getReference().getName());
            return type.hasOperation(selectedField.getName());
        }
        return false;
    }

    private boolean isScalar(SelectedField field) {
        GraphQLType graphQLType = this.unwrapGraphQLType((GraphQLType)field.getFieldDefinition().getType());
        return this.isScalar(graphQLType);
    }

    private boolean isScalar(GraphQLType gqlt) {
        return GraphQLScalarType.class.isAssignableFrom(gqlt.getClass());
    }

    private GraphQLType unwrapGraphQLType(GraphQLType gqlt) {
        if (this.isNonNull(gqlt)) {
            GraphQLNonNull graphQLNonNull = (GraphQLNonNull)gqlt;
            return this.unwrapGraphQLType(graphQLNonNull.getWrappedType());
        }
        if (this.isList(gqlt)) {
            GraphQLList graphQLList = (GraphQLList)gqlt;
            return this.unwrapGraphQLType(graphQLList.getWrappedType());
        }
        return gqlt;
    }

    private boolean isNonNull(GraphQLType gqlt) {
        return GraphQLNonNull.class.isAssignableFrom(gqlt.getClass());
    }

    private boolean isList(GraphQLType gqlt) {
        return GraphQLList.class.isAssignableFrom(gqlt.getClass());
    }

    private boolean isFlattenScalar(SelectedField field) {
        return field.getQualifiedName().contains("/");
    }

    static {
        current = new ThreadLocal();
    }
}

