/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.datafetcher;

import graphql.GraphQLContext;
import graphql.execution.DataFetcherResult;
import graphql.schema.DataFetchingEnvironment;
import io.smallrye.graphql.SmallRyeGraphQLServerMessages;
import io.smallrye.graphql.execution.datafetcher.AbstractDataFetcher;
import io.smallrye.graphql.execution.datafetcher.ExecutionContextImpl;
import io.smallrye.graphql.execution.datafetcher.decorator.DataFetcherDecorator;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.transformation.AbstractDataFetcherException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import org.eclipse.microprofile.graphql.GraphQLException;

public class AsyncDataFetcher
extends AbstractDataFetcher<CompletionStage<DataFetcherResult<Object>>> {
    public AsyncDataFetcher(Operation operation) {
        this(operation, Collections.emptyList());
    }

    public AsyncDataFetcher(Operation operation, Collection<DataFetcherDecorator> decorators) {
        super(operation, decorators);
    }

    @Override
    protected CompletionStage<DataFetcherResult<Object>> fetch(DataFetchingEnvironment dfe) throws Exception {
        GraphQLContext context = GraphQLContext.newContext().build();
        DataFetcherResult.Builder resultBuilder = DataFetcherResult.newResult().localContext((Object)context);
        Class<?> operationClass = this.classloadingService.loadClass(this.operation.getClassName());
        Method m = this.getMethod(operationClass);
        Object declaringObject = this.lookupService.getInstance(operationClass);
        try {
            Object[] transformedArguments = this.argumentHelper.getArguments(dfe);
            ExecutionContextImpl executionContext = new ExecutionContextImpl(declaringObject, m, transformedArguments, context, dfe, this.decorators.iterator());
            CompletionStage futureResult = (CompletionStage)this.execute(executionContext);
            return futureResult.handle((result, throwable) -> {
                if (throwable instanceof CompletionException) {
                    throwable = throwable.getCause();
                }
                if (throwable != null) {
                    if (throwable instanceof GraphQLException) {
                        GraphQLException graphQLException = (GraphQLException)((Object)throwable);
                        this.appendPartialResult((DataFetcherResult.Builder<Object>)resultBuilder, dfe, graphQLException);
                    } else {
                        if (throwable instanceof Exception) {
                            throw SmallRyeGraphQLServerMessages.msg.dataFetcherException(this.operation, (Throwable)throwable);
                        }
                        if (throwable instanceof Error) {
                            throw (Error)throwable;
                        }
                    }
                } else {
                    try {
                        resultBuilder.data(this.fieldHelper.transformResponse(result));
                    }
                    catch (AbstractDataFetcherException te) {
                        te.appendDataFetcherResult((DataFetcherResult.Builder<Object>)resultBuilder, dfe);
                    }
                }
                return resultBuilder.build();
            });
        }
        catch (AbstractDataFetcherException pe) {
            pe.appendDataFetcherResult((DataFetcherResult.Builder<Object>)resultBuilder, dfe);
        }
        catch (GraphQLException graphQLException) {
            this.appendPartialResult((DataFetcherResult.Builder<Object>)resultBuilder, dfe, graphQLException);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException ex) {
            throw SmallRyeGraphQLServerMessages.msg.dataFetcherException(this.operation, ex);
        }
        return CompletableFuture.completedFuture(resultBuilder.build());
    }
}

