/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.datafetcher;

import io.smallrye.graphql.SmallRyeGraphQLServerLogging;
import io.smallrye.graphql.spi.ClassloadingService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class CollectionCreator {
    private static ClassloadingService classloadingService = ClassloadingService.load();

    public static Collection<?> newCollection(String className) {
        Class<?> type = classloadingService.loadClass(className);
        return CollectionCreator.newCollection(type);
    }

    private static Collection<?> newCollection(Class<?> type) {
        try {
            return (Collection)type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            SmallRyeGraphQLServerLogging.log.noArgConstructorMissing(type == null ? "null" : type.getName());
            if (Set.class.isAssignableFrom(type)) {
                return new HashSet();
            }
            return new ArrayList();
        }
    }
}

