/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.datafetcher.decorator;

import graphql.GraphQLContext;
import graphql.schema.DataFetchingEnvironment;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.smallrye.graphql.execution.SpanNaming;
import io.smallrye.graphql.execution.datafetcher.ExecutionContext;
import io.smallrye.graphql.execution.datafetcher.decorator.AbstractDataFetcherDecorator;
import io.smallrye.graphql.execution.datafetcher.helper.NameHelper;
import io.smallrye.graphql.spi.OpenTracingService;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.CompletionException;

public class OpenTracingDecorator
extends AbstractDataFetcherDecorator {
    private static final Object PARENT_SPAN_KEY = Span.class;
    OpenTracingService openTracingService = OpenTracingService.load();
    private final Map<ExecutionContext, Span> spans = Collections.synchronizedMap(new IdentityHashMap());

    @Override
    protected void onError(ExecutionContext executionContext, Throwable throwable) {
        Span span = this.spans.get(executionContext);
        this.logError(span, throwable);
    }

    @Override
    protected void before(ExecutionContext executionContext) {
        DataFetchingEnvironment env = executionContext.dataFetchingEnvironment();
        Tracer tracer = this.openTracingService.getTracer();
        Span parentSpan = this.getParentSpan(tracer, env);
        Scope scope = tracer.buildSpan(SpanNaming.getOperationName(env)).asChildOf(parentSpan).withTag("graphql.executionId", env.getExecutionId().toString()).withTag("graphql.operationName", env.getOperationDefinition().getName()).withTag("graphql.parent", NameHelper.getName(env.getParentType())).withTag("graphql.field", env.getField().getName()).withTag("graphql.path", env.getExecutionStepInfo().getPath().toString()).startActive(false);
        Span span = scope.span();
        executionContext.newGraphQLContext().put(PARENT_SPAN_KEY, (Object)span);
        this.spans.put(executionContext, span);
    }

    @Override
    protected void after(ExecutionContext executionContext) {
        Span span = this.spans.remove(executionContext);
        span.finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(ExecutionContext executionContext) throws Exception {
        try {
            Object object = super.execute(executionContext);
            return object;
        }
        finally {
            Tracer tracer = this.openTracingService.getTracer();
            tracer.scopeManager().active().close();
        }
    }

    private void logError(Span span, Throwable throwable) {
        if (throwable instanceof InvocationTargetException || throwable instanceof CompletionException) {
            throwable = throwable.getCause();
        }
        HashMap<String, String> error = new HashMap<String, String>();
        error.put("error.object", throwable.getMessage());
        error.put("event", "error");
        span.log(error);
        span.setTag("error", true);
    }

    private Span getParentSpan(Tracer tracer, DataFetchingEnvironment env) {
        GraphQLContext localContext = (GraphQLContext)env.getLocalContext();
        if (localContext != null && localContext.hasKey(PARENT_SPAN_KEY)) {
            return (Span)localContext.get(PARENT_SPAN_KEY);
        }
        GraphQLContext rootContext = (GraphQLContext)env.getContext();
        if (rootContext != null && rootContext.hasKey(PARENT_SPAN_KEY)) {
            return (Span)rootContext.get(PARENT_SPAN_KEY);
        }
        return tracer.activeSpan();
    }
}

