/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.datafetcher.helper;

import graphql.schema.DataFetchingEnvironment;
import io.smallrye.graphql.SmallRyeGraphQLServerLogging;
import io.smallrye.graphql.execution.Classes;
import io.smallrye.graphql.execution.datafetcher.helper.AbstractHelper;
import io.smallrye.graphql.json.InputFieldsInfo;
import io.smallrye.graphql.json.JsonBCreator;
import io.smallrye.graphql.schema.model.Argument;
import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.MappingInfo;
import io.smallrye.graphql.schema.model.ReferenceType;
import io.smallrye.graphql.transformation.AbstractDataFetcherException;
import io.smallrye.graphql.transformation.TransformException;
import io.smallrye.graphql.transformation.Transformer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbException;

public class ArgumentHelper
extends AbstractHelper {
    private final List<Argument> arguments;

    public ArgumentHelper(List<Argument> arguments) {
        this.arguments = arguments;
    }

    public Object[] getArguments(DataFetchingEnvironment dfe) throws AbstractDataFetcherException {
        Object[] argumentObjects = new Object[this.arguments.size()];
        int idx = 0;
        for (Argument argument : this.arguments) {
            Object argumentValue;
            argumentObjects[idx] = argumentValue = this.getArgument(dfe, argument);
            ++idx;
        }
        return argumentObjects;
    }

    private Object getArgument(DataFetchingEnvironment dfe, Argument argument) throws AbstractDataFetcherException {
        Object source;
        if (argument.isSourceArgument() && (source = dfe.getSource()) != null) {
            return source;
        }
        Object argumentValueFromGraphQLJava = dfe.getArgument(argument.getName());
        if (argumentValueFromGraphQLJava == null) {
            return null;
        }
        return super.recursiveTransform(argumentValueFromGraphQLJava, (Field)argument);
    }

    @Override
    Object singleTransform(Object argumentValue, Field field) throws AbstractDataFetcherException {
        return Transformer.in(field, argumentValue);
    }

    @Override
    Object singleMapping(Object argumentValue, Field field) throws AbstractDataFetcherException {
        if (this.shouldApplyMapping(field)) {
            String expectedType = field.getReference().getClassName();
            Class<?> expectedClass = this.classloadingService.loadClass(expectedType);
            if (this.getCreate(field).equals((Object)MappingInfo.Create.CONSTRUCTOR)) {
                try {
                    Constructor<?> constructor = expectedClass.getConstructor(argumentValue.getClass());
                    return constructor.newInstance(argumentValue);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException constructor) {}
            } else if (this.getCreate(field).equals((Object)MappingInfo.Create.SET_VALUE)) {
                try {
                    Method setValueMethod = expectedClass.getMethod("setValue", argumentValue.getClass());
                    Constructor<?> constructor = expectedClass.getConstructor(new Class[0]);
                    Object instance = constructor.newInstance(new Object[0]);
                    setValueMethod.invoke(instance, argumentValue);
                    return instance;
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException setValueMethod) {}
            } else if (this.getCreate(field).equals((Object)MappingInfo.Create.STATIC_FROM)) {
                try {
                    String simpleClassName = argumentValue.getClass().getSimpleName();
                    String staticMethodName = "from" + simpleClassName;
                    Method staticFromMethod = expectedClass.getMethod(staticMethodName, argumentValue.getClass());
                    Object instance = staticFromMethod.invoke(null, argumentValue);
                    return instance;
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                    // empty catch block
                }
            }
        }
        return argumentValue;
    }

    private boolean shouldApplyMapping(Field field) {
        return field.getReference().hasMappingInfo() && !field.getReference().getMappingInfo().getCreate().equals((Object)MappingInfo.Create.NONE) || field.hasMappingInfo() && !field.getMappingInfo().getCreate().equals((Object)MappingInfo.Create.NONE);
    }

    private MappingInfo.Create getCreate(Field field) {
        if (field.getReference().hasMappingInfo()) {
            return field.getReference().getMappingInfo().getCreate();
        }
        if (field.hasMappingInfo()) {
            return field.getMappingInfo().getCreate();
        }
        return MappingInfo.Create.NONE;
    }

    @Override
    protected Object afterRecursiveTransform(Object fieldValue, Field field) throws AbstractDataFetcherException {
        String receivedType;
        String expectedType = field.getReference().getClassName();
        if (expectedType.equals(receivedType = fieldValue.getClass().getName())) {
            return fieldValue;
        }
        if (Classes.isPrimitiveOf(expectedType, receivedType)) {
            return fieldValue;
        }
        if (field.getReference().getType().equals((Object)ReferenceType.ENUM)) {
            Class<?> enumClass = this.classloadingService.loadClass(field.getReference().getClassName());
            return Enum.valueOf(enumClass, fieldValue.toString());
        }
        return this.correctObjectClass(fieldValue, field);
    }

    private Object correctObjectClass(Object argumentValue, Field field) throws AbstractDataFetcherException {
        String receivedClassName = argumentValue.getClass().getName();
        if (Map.class.isAssignableFrom(argumentValue.getClass())) {
            return this.correctComplexObjectFromMap((Map)argumentValue, field);
        }
        if (receivedClassName.equals(String.class.getName())) {
            return this.correctComplexObjectFromJsonString(argumentValue.toString(), field);
        }
        SmallRyeGraphQLServerLogging.log.dontKnowHoToHandleArgument(field.getMethodName());
        return argumentValue;
    }

    private Object correctComplexObjectFromMap(Map m, Field field) throws AbstractDataFetcherException {
        String fieldName;
        String className = field.getReference().getClassName();
        if (InputFieldsInfo.hasTransformationFields(className)) {
            Map<String, Field> transformationFields = InputFieldsInfo.getTransformationFields(className);
            for (Map.Entry<String, Field> entry : transformationFields.entrySet()) {
                fieldName = entry.getKey();
                if (!m.containsKey(fieldName)) continue;
                Object valueThatShouldTransform = m.get(fieldName);
                Field fieldThatShouldTransform = entry.getValue();
                valueThatShouldTransform = this.recursiveTransform(valueThatShouldTransform, fieldThatShouldTransform);
                m.put(fieldName, valueThatShouldTransform);
            }
        }
        if (InputFieldsInfo.hasMappingFields(className)) {
            Map<String, Field> mappingFields = InputFieldsInfo.getMappingFields(className);
            for (Map.Entry<String, Field> entry : mappingFields.entrySet()) {
                fieldName = entry.getKey();
                if (!m.containsKey(fieldName)) continue;
                Object valueThatShouldMap = m.get(fieldName);
                Field fieldThatShouldMap = entry.getValue();
                valueThatShouldMap = this.recursiveMapping(valueThatShouldMap, fieldThatShouldMap);
                m.put(fieldName, valueThatShouldMap);
            }
        }
        String jsonString = JsonBCreator.getJsonB().toJson((Object)m);
        return this.correctComplexObjectFromJsonString(jsonString, field);
    }

    private Object correctComplexObjectFromJsonString(String jsonString, Field field) throws AbstractDataFetcherException {
        Class<?> ownerClass = this.classloadingService.loadClass(field.getReference().getClassName());
        try {
            Jsonb jsonb = JsonBCreator.getJsonB(field.getReference().getClassName());
            return jsonb.fromJson(jsonString, ownerClass);
        }
        catch (JsonbException jbe) {
            throw new TransformException(jbe, field, jsonString);
        }
    }
}

