/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.datafetcher.helper;

import io.smallrye.graphql.SmallRyeGraphQLServerLogging;
import io.smallrye.graphql.execution.datafetcher.helper.AbstractHelper;
import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.transformation.AbstractDataFetcherException;
import io.smallrye.graphql.transformation.TransformException;
import io.smallrye.graphql.transformation.Transformer;

public class FieldHelper
extends AbstractHelper {
    private final Field field;

    public FieldHelper(Field field) {
        this.field = field;
    }

    public Object transformResponse(Object argumentValue) throws AbstractDataFetcherException {
        if (!this.shouldTransform(this.field)) {
            return argumentValue;
        }
        argumentValue = super.recursiveTransform(argumentValue, this.field);
        return argumentValue;
    }

    @Override
    Object singleTransform(Object argumentValue, Field field) throws AbstractDataFetcherException {
        if (!this.shouldTransform(field)) {
            return argumentValue;
        }
        return this.transformOutput(field, argumentValue);
    }

    @Override
    Object singleMapping(Object argumentValue, Field field) throws AbstractDataFetcherException {
        return argumentValue;
    }

    @Override
    protected Object afterRecursiveTransform(Object fieldValue, Field field) {
        return fieldValue;
    }

    @Override
    protected Class<?> getArrayType(Field field) {
        return this.classloadingService.loadClass(field.getReference().getGraphQlClassName());
    }

    private Object transformOutput(Field field, Object object) throws AbstractDataFetcherException {
        if (object == null) {
            return null;
        }
        if (!this.shouldTransform(field)) {
            return object;
        }
        try {
            Transformer transformer = super.getTransformer(field);
            if (transformer == null) {
                return object;
            }
            return transformer.out(object);
        }
        catch (Exception e) {
            SmallRyeGraphQLServerLogging.log.transformError(e);
            throw new TransformException(e, field, object);
        }
    }
}

