/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution;

import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.GraphQLContext;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.ExecutionId;
import graphql.execution.ExecutionStrategy;
import graphql.execution.SubscriptionExecutionStrategy;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.preparsed.PreparsedDocumentProvider;
import graphql.schema.GraphQLSchema;
import io.smallrye.graphql.SmallRyeGraphQLServerLogging;
import io.smallrye.graphql.api.Context;
import io.smallrye.graphql.bootstrap.Config;
import io.smallrye.graphql.bootstrap.DataFetcherFactory;
import io.smallrye.graphql.execution.ExecutionResponse;
import io.smallrye.graphql.execution.QueryCache;
import io.smallrye.graphql.execution.context.SmallRyeBatchLoaderContextProvider;
import io.smallrye.graphql.execution.context.SmallRyeContext;
import io.smallrye.graphql.execution.datafetcher.helper.BatchLoaderHelper;
import io.smallrye.graphql.execution.error.ExceptionHandler;
import io.smallrye.graphql.execution.event.EventEmitter;
import io.smallrye.graphql.schema.model.Operation;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import javax.json.JsonObject;
import org.dataloader.BatchLoaderContextProvider;
import org.dataloader.BatchLoaderWithContext;
import org.dataloader.DataLoader;
import org.dataloader.DataLoaderOptions;
import org.dataloader.DataLoaderRegistry;

public class ExecutionService {
    private final String executionIdPrefix;
    private final AtomicLong executionId = new AtomicLong();
    private final Config config;
    private final GraphQLSchema graphQLSchema;
    private final BatchLoaderHelper batchLoaderHelper = new BatchLoaderHelper();
    private final DataFetcherFactory dataFetcherFactory;
    private final List<Operation> batchOperations;
    private final EventEmitter eventEmitter;
    private GraphQL graphQL;
    private final boolean hasSubscription;
    private final QueryCache queryCache;

    public ExecutionService(Config config, GraphQLSchema graphQLSchema, List<Operation> batchOperations, boolean hasSubscription) {
        this.config = config;
        this.graphQLSchema = graphQLSchema;
        this.dataFetcherFactory = new DataFetcherFactory(config);
        this.batchOperations = batchOperations;
        this.eventEmitter = EventEmitter.getInstance(config);
        this.executionIdPrefix = Integer.toString(Objects.hashCode(graphQLSchema));
        this.hasSubscription = hasSubscription;
        this.queryCache = new QueryCache();
    }

    public ExecutionResponse execute(JsonObject jsonInput) {
        SmallRyeContext context = new SmallRyeContext(jsonInput);
        ExecutionId finalExecutionId = ExecutionId.from((String)(this.executionIdPrefix + this.executionId.getAndIncrement()));
        try {
            GraphQL g;
            String query = context.getQuery();
            if (query == null || query.isEmpty()) {
                throw new RuntimeException("Query can not be null");
            }
            if (this.config.logPayload()) {
                SmallRyeGraphQLServerLogging.log.payloadIn(query);
            }
            if ((g = this.getGraphQL()) != null) {
                ExecutionInput.Builder executionBuilder = ExecutionInput.newExecutionInput().query(query).executionId(finalExecutionId);
                context.getVariables().ifPresent(arg_0 -> ((ExecutionInput.Builder)executionBuilder).variables(arg_0));
                context.getOperationName().ifPresent(arg_0 -> ((ExecutionInput.Builder)executionBuilder).operationName(arg_0));
                executionBuilder.context((Object)this.toGraphQLContext(context));
                if (this.batchOperations != null && !this.batchOperations.isEmpty()) {
                    DataLoaderRegistry dataLoaderRegistry = this.getDataLoaderRegistry(this.batchOperations);
                    executionBuilder.dataLoaderRegistry(dataLoaderRegistry);
                }
                ExecutionInput executionInput = executionBuilder.build();
                context = context.withDataFromExecution(executionInput, this.queryCache);
                ((GraphQLContext)executionInput.getContext()).put((Object)"context", (Object)context);
                this.eventEmitter.fireBeforeExecute(context);
                ExecutionResult executionResult = g.execute(executionInput);
                this.eventEmitter.fireAfterExecute(context);
                ExecutionResponse executionResponse = new ExecutionResponse(executionResult, this.config);
                if (this.config.logPayload()) {
                    SmallRyeGraphQLServerLogging.log.payloadOut(executionResponse.toString());
                }
                return executionResponse;
            }
            SmallRyeGraphQLServerLogging.log.noGraphQLMethodsFound();
            return null;
        }
        catch (Throwable t) {
            this.eventEmitter.fireOnExecuteError(finalExecutionId.toString(), t);
            throw t;
        }
    }

    private <K, T> DataLoaderRegistry getDataLoaderRegistry(List<Operation> operations) {
        DataLoaderRegistry dataLoaderRegistry = new DataLoaderRegistry();
        for (Operation operation : operations) {
            BatchLoaderWithContext batchLoader = this.dataFetcherFactory.getSourceBatchLoader(operation);
            SmallRyeBatchLoaderContextProvider ctxProvider = new SmallRyeBatchLoaderContextProvider();
            DataLoaderOptions options = DataLoaderOptions.newOptions().setBatchLoaderContextProvider((BatchLoaderContextProvider)ctxProvider);
            DataLoader dataLoader = DataLoader.newDataLoader(batchLoader, (DataLoaderOptions)options);
            ctxProvider.setDataLoader(dataLoader);
            dataLoaderRegistry.register(this.batchLoaderHelper.getName(operation), dataLoader);
        }
        return dataLoaderRegistry;
    }

    private GraphQLContext toGraphQLContext(Context context) {
        GraphQLContext.Builder builder = GraphQLContext.newContext();
        builder = builder.of((Object)"context", (Object)context);
        return builder.build();
    }

    private GraphQL getGraphQL() {
        if (this.graphQL == null) {
            ExceptionHandler exceptionHandler = new ExceptionHandler(this.config);
            if (this.graphQLSchema != null) {
                GraphQL.Builder graphqlBuilder = GraphQL.newGraphQL((GraphQLSchema)this.graphQLSchema);
                graphqlBuilder = graphqlBuilder.defaultDataFetcherExceptionHandler((DataFetcherExceptionHandler)exceptionHandler);
                graphqlBuilder = graphqlBuilder.instrumentation((Instrumentation)this.queryCache);
                graphqlBuilder = graphqlBuilder.preparsedDocumentProvider((PreparsedDocumentProvider)this.queryCache);
                if (this.hasSubscription) {
                    graphqlBuilder = graphqlBuilder.subscriptionExecutionStrategy((ExecutionStrategy)new SubscriptionExecutionStrategy());
                }
                graphqlBuilder = this.eventEmitter.fireBeforeGraphQLBuild(graphqlBuilder);
                this.graphQL = graphqlBuilder.build();
            } else {
                SmallRyeGraphQLServerLogging.log.noGraphQLMethodsFound();
            }
        }
        return this.graphQL;
    }
}

