/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql;

import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import io.smallrye.graphql.SmallRyeGraphQLServerMessages;
import io.smallrye.graphql.execution.datafetcher.DataFetcherException;
import io.smallrye.graphql.execution.resolver.ConcreteImplementationNotFoundException;
import io.smallrye.graphql.schema.model.Operation;
import java.io.Serializable;
import java.time.DateTimeException;
import java.util.Arrays;
import java.util.Locale;

public class SmallRyeGraphQLServerMessages_$bundle
implements SmallRyeGraphQLServerMessages,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final SmallRyeGraphQLServerMessages_$bundle INSTANCE = new SmallRyeGraphQLServerMessages_$bundle();
    private static final Locale LOCALE = Locale.ROOT;

    protected SmallRyeGraphQLServerMessages_$bundle() {
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String concreteClassNotFoundForInterface$str() {
        return "No concrete class named [%s] found for interface [%s]";
    }

    @Override
    public final ConcreteImplementationNotFoundException concreteClassNotFoundForInterface(String clazz, String iface) {
        ConcreteImplementationNotFoundException result = new ConcreteImplementationNotFoundException(String.format(this.getLoggingLocale(), this.concreteClassNotFoundForInterface$str(), clazz, iface));
        SmallRyeGraphQLServerMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String unknownPrimitiveType$str() {
        return "SRGQL000001: Unknown primitive type [%s]";
    }

    @Override
    public final ClassNotFoundException unknownPrimitiveType(String name) {
        ClassNotFoundException result = new ClassNotFoundException(String.format(this.getLoggingLocale(), this.unknownPrimitiveType$str(), name));
        SmallRyeGraphQLServerMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String dataFetcherException$str() {
        return "SRGQL000002: Data fetching failed for operation [%s]";
    }

    @Override
    public final DataFetcherException dataFetcherException(Operation operation, Throwable cause) {
        DataFetcherException result = new DataFetcherException();
        result.initCause(cause);
        SmallRyeGraphQLServerMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String countNotGetInstance$str() {
        return "SRGQL000005: Could not get Instance using the default lookup service";
    }

    @Override
    public final RuntimeException countNotGetInstance(Throwable t) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.countNotGetInstance$str(), new Object[0]), t);
        SmallRyeGraphQLServerMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String metricsNotSupportedWithoutCDI$str() {
        return "SRGQL000006: Metrics are not supported without CDI";
    }

    @Override
    public final UnsupportedOperationException metricsNotSupportedWithoutCDI() {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.getLoggingLocale(), this.metricsNotSupportedWithoutCDI$str(), new Object[0]));
        SmallRyeGraphQLServerMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String openTracingNotSupportedWithoutCDI$str() {
        return "SRGQL000008: OpenTracing is not supported without CDI";
    }

    @Override
    public final UnsupportedOperationException openTracingNotSupportedWithoutCDI() {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.getLoggingLocale(), this.openTracingNotSupportedWithoutCDI$str(), new Object[0]));
        SmallRyeGraphQLServerMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String canNotLoadClass$str() {
        return "SRGQL000009: Can not load class [%s]";
    }

    @Override
    public final RuntimeException canNotLoadClass(String className, Exception cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.canNotLoadClass$str(), className), cause);
        SmallRyeGraphQLServerMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String notAValidNumberType$str() {
        return "SRGQL000010: [%s] is not a valid number type";
    }

    @Override
    public final RuntimeException notAValidNumberType(String typeClassName) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.notAValidNumberType$str(), typeClassName));
        SmallRyeGraphQLServerMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String numberFormatException$str() {
        return "SRGQL000011: Can not parse a number from [%s]";
    }

    @Override
    public final NumberFormatException numberFormatException(String input) {
        NumberFormatException result = new NumberFormatException(String.format(this.getLoggingLocale(), this.numberFormatException$str(), input));
        SmallRyeGraphQLServerMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String coercingSerializeException$str() {
        return "SRGQL000012: Expected type [%s] but was [%s].";
    }

    @Override
    public final CoercingSerializeException coercingSerializeException(String expectedType, String actualType, Exception cause) {
        CoercingSerializeException result = new CoercingSerializeException(String.format(this.getLoggingLocale(), this.coercingSerializeException$str(), expectedType, actualType), (Throwable)cause);
        SmallRyeGraphQLServerMessages_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String coercingParseValueException$str() {
        return "SRGQL000013: Expected type [%s] but was [%s].";
    }

    @Override
    public final CoercingParseValueException coercingParseValueException(String expectedType, String actualType, Exception cause) {
        CoercingParseValueException result = new CoercingParseValueException(String.format(this.getLoggingLocale(), this.coercingParseValueException$str(), expectedType, actualType), (Throwable)cause);
        SmallRyeGraphQLServerMessages_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String coercingParseLiteralException2$str() {
        return "SRGQL000014: Expected value to be in the %s range but it was '%s'";
    }

    @Override
    public final CoercingParseLiteralException coercingParseLiteralException(String expectedRange, String actual) {
        CoercingParseLiteralException result = new CoercingParseLiteralException(String.format(this.getLoggingLocale(), this.coercingParseLiteralException2$str(), expectedRange, actual));
        SmallRyeGraphQLServerMessages_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String coercingParseLiteralException1$str() {
        return "SRGQL000015: Expected AST type 'IntValue' or 'StringValue' but was '%s'.";
    }

    @Override
    public final CoercingParseLiteralException coercingParseLiteralException(String actualType) {
        CoercingParseLiteralException result = new CoercingParseLiteralException(String.format(this.getLoggingLocale(), this.coercingParseLiteralException1$str(), actualType));
        SmallRyeGraphQLServerMessages_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cantParseDate$str() {
        return "SRGQL000016: Can't parse [%s] into [%s]";
    }

    @Override
    public final RuntimeException cantParseDate(String inputTypeName, String targetClassName) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.cantParseDate$str(), inputTypeName, targetClassName));
        SmallRyeGraphQLServerMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String notValidDateOrTimeType$str() {
        return "SRGQL000017: [%s] is no valid date or time-type";
    }

    @Override
    public final RuntimeException notValidDateOrTimeType(String className) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.notValidDateOrTimeType$str(), className));
        SmallRyeGraphQLServerMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownDateFormat$str() {
        return "SRGQL000018: Unknown date format [%s]";
    }

    @Override
    public final DateTimeException unknownDateFormat(String input) {
        DateTimeException result = new DateTimeException(String.format(this.getLoggingLocale(), this.unknownDateFormat$str(), input));
        SmallRyeGraphQLServerMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unsupportedWrappedClass$str() {
        return "SRGQL000019: Unsupported wrapped type. SmallRye only support DataFetchingEnvironment and not %s";
    }

    @Override
    public final IllegalArgumentException unsupportedWrappedClass(String className) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unsupportedWrappedClass$str(), className));
        SmallRyeGraphQLServerMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String canNotInjectClass$str() {
        return "SRGQL000020: Can not inject an instance of class [%s]. Please make sure it is a CDI bean, also possibly the beans.xml file is needed";
    }

    @Override
    public final RuntimeException canNotInjectClass(String className, Exception cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.canNotInjectClass$str(), className), cause);
        SmallRyeGraphQLServerMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }
}

