/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.bootstrap;

import graphql.introspection.Introspection;
import graphql.schema.DataFetcher;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import graphql.schema.TypeResolver;
import graphql.schema.visibility.BlockedFields;
import graphql.schema.visibility.DefaultGraphqlFieldVisibility;
import graphql.schema.visibility.GraphqlFieldVisibility;
import graphql.schema.visibility.NoIntrospectionGraphqlFieldVisibility;
import io.smallrye.graphql.SmallRyeGraphQLServerLogging;
import io.smallrye.graphql.SmallRyeGraphQLServerMessages;
import io.smallrye.graphql.bootstrap.DataFetcherFactory;
import io.smallrye.graphql.execution.Classes;
import io.smallrye.graphql.execution.context.SmallRyeContext;
import io.smallrye.graphql.execution.datafetcher.BatchDataFetcher;
import io.smallrye.graphql.execution.datafetcher.CollectionCreator;
import io.smallrye.graphql.execution.datafetcher.FieldDataFetcher;
import io.smallrye.graphql.execution.error.ErrorInfoMap;
import io.smallrye.graphql.execution.event.EventEmitter;
import io.smallrye.graphql.execution.resolver.InterfaceOutputRegistry;
import io.smallrye.graphql.execution.resolver.InterfaceResolver;
import io.smallrye.graphql.json.JsonBCreator;
import io.smallrye.graphql.json.JsonInputRegistry;
import io.smallrye.graphql.scalar.GraphQLScalarTypes;
import io.smallrye.graphql.schema.model.Argument;
import io.smallrye.graphql.schema.model.DirectiveArgument;
import io.smallrye.graphql.schema.model.DirectiveInstance;
import io.smallrye.graphql.schema.model.DirectiveType;
import io.smallrye.graphql.schema.model.EnumType;
import io.smallrye.graphql.schema.model.EnumValue;
import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.Group;
import io.smallrye.graphql.schema.model.InputType;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.schema.model.Reference;
import io.smallrye.graphql.schema.model.ReferenceType;
import io.smallrye.graphql.schema.model.Schema;
import io.smallrye.graphql.schema.model.Type;
import io.smallrye.graphql.schema.model.Wrapper;
import io.smallrye.graphql.spi.ClassloadingService;
import io.smallrye.graphql.spi.LookupService;
import io.smallrye.graphql.spi.config.Config;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.json.Json;
import javax.json.JsonReaderFactory;
import javax.json.bind.Jsonb;

public class Bootstrap {
    private final Schema schema;
    private final EventEmitter eventEmitter = EventEmitter.getInstance();
    private final DataFetcherFactory dataFetcherFactory = new DataFetcherFactory();
    private final Set<GraphQLDirective> directiveTypes = new LinkedHashSet<GraphQLDirective>();
    private final Map<String, GraphQLEnumType> enumMap = new HashMap<String, GraphQLEnumType>();
    private final Map<String, GraphQLInterfaceType> interfaceMap = new HashMap<String, GraphQLInterfaceType>();
    private final Map<String, GraphQLInputObjectType> inputMap = new HashMap<String, GraphQLInputObjectType>();
    private final Map<String, GraphQLObjectType> typeMap = new HashMap<String, GraphQLObjectType>();
    private GraphQLSchema graphQLSchema;
    private final GraphQLCodeRegistry.Builder codeRegistryBuilder = GraphQLCodeRegistry.newCodeRegistry();
    private final ClassloadingService classloadingService = ClassloadingService.get();
    private static final String QUERY = "Query";
    private static final String QUERY_DESCRIPTION = "Query root";
    private static final String MUTATION = "Mutation";
    private static final String MUTATION_DESCRIPTION = "Mutation root";
    private static final String SUBSCRIPTION = "Subscription";
    private static final String SUBSCRIPTION_DESCRIPTION = "Subscription root";
    private static final String COMMA = ",";
    private static final JsonReaderFactory jsonReaderFactory = Json.createReaderFactory(null);
    private static final String CONTEXT = "io.smallrye.graphql.api.Context";
    private static final String OBSERVES = "javax.enterprise.event.Observes";
    private static final List<String> IGNORABLE_ARGUMENTS = Arrays.asList("io.smallrye.graphql.api.Context", "javax.enterprise.event.Observes");

    public static GraphQLSchema bootstrap(Schema schema) {
        return Bootstrap.bootstrap(schema, false);
    }

    public static GraphQLSchema bootstrap(Schema schema, boolean allowMultipleDeployments) {
        if (schema != null && schema.hasOperations()) {
            Bootstrap bootstrap = new Bootstrap(schema, allowMultipleDeployments);
            bootstrap.generateGraphQLSchema();
            return bootstrap.graphQLSchema;
        }
        SmallRyeGraphQLServerLogging.log.emptyOrNullSchema();
        return null;
    }

    private Bootstrap(Schema schema, boolean allowMultipleDeployments) {
        this.schema = schema;
        SmallRyeContext.setSchema(schema, allowMultipleDeployments);
        if (!Boolean.getBoolean("test.skip.injection.validation")) {
            this.verifyInjectionIsAvailable();
        }
    }

    private void verifyInjectionIsAvailable() {
        LookupService lookupService = LookupService.get();
        ClassloadingService classloadingService = ClassloadingService.get();
        Stream.of(this.schema.getQueries().stream().map(Operation::getClassName), this.schema.getMutations().stream().map(Operation::getClassName), this.schema.getGroupedQueries().values().stream().flatMap(Collection::stream).map(Operation::getClassName), this.schema.getGroupedMutations().values().stream().flatMap(Collection::stream).map(Operation::getClassName)).flatMap(stream -> stream).distinct().forEach(beanClassName -> {
            if (!lookupService.isResolvable(classloadingService.loadClass((String)beanClassName))) {
                throw SmallRyeGraphQLServerMessages.msg.canNotInjectClass((String)beanClassName, null);
            }
        });
    }

    private void generateGraphQLSchema() {
        GraphQLSchema.Builder schemaBuilder = GraphQLSchema.newSchema();
        this.createGraphQLDirectiveTypes();
        this.createGraphQLEnumTypes();
        this.createGraphQLInterfaceTypes();
        this.createGraphQLObjectTypes();
        this.createGraphQLInputObjectTypes();
        this.addQueries(schemaBuilder);
        this.addMutations(schemaBuilder);
        this.addSubscriptions(schemaBuilder);
        schemaBuilder.additionalDirectives(this.directiveTypes);
        schemaBuilder.additionalTypes(new HashSet<GraphQLEnumType>(this.enumMap.values()));
        schemaBuilder.additionalTypes(new HashSet<GraphQLInterfaceType>(this.interfaceMap.values()));
        schemaBuilder.additionalTypes(new HashSet<GraphQLObjectType>(this.typeMap.values()));
        schemaBuilder.additionalTypes(new HashSet<GraphQLInputObjectType>(this.inputMap.values()));
        this.codeRegistryBuilder.fieldVisibility(this.getGraphqlFieldVisibility());
        schemaBuilder = schemaBuilder.codeRegistry(this.codeRegistryBuilder.build());
        ErrorInfoMap.register(this.schema.getErrors());
        schemaBuilder = this.eventEmitter.fireBeforeSchemaBuild(schemaBuilder);
        this.graphQLSchema = schemaBuilder.build();
    }

    private void createGraphQLDirectiveTypes() {
        if (this.schema.hasDirectiveTypes()) {
            for (DirectiveType directiveType : this.schema.getDirectiveTypes()) {
                this.createGraphQLDirectiveType(directiveType);
            }
        }
    }

    private void createGraphQLDirectiveType(DirectiveType directiveType) {
        GraphQLDirective.Builder directiveBuilder = GraphQLDirective.newDirective().name(directiveType.getName()).description(directiveType.getDescription());
        for (String location : directiveType.getLocations()) {
            directiveBuilder.validLocation(Introspection.DirectiveLocation.valueOf((String)location));
        }
        for (String argumentName : directiveType.getArgumentNames()) {
            GraphQLInputType argumentType = this.argumentType(directiveType.getArgumentType(argumentName));
            directiveBuilder = directiveBuilder.argument(GraphQLArgument.newArgument().type(argumentType).name(argumentName).build());
        }
        this.directiveTypes.add(directiveBuilder.build());
    }

    private GraphQLInputType argumentType(DirectiveArgument argumentType) {
        GraphQLInputType inputType = this.getGraphQLInputType(argumentType.getReference());
        if (argumentType.hasWrapper() && argumentType.getWrapper().isCollectionOrArray()) {
            inputType = GraphQLList.list((GraphQLType)inputType);
        }
        return inputType;
    }

    private void addQueries(GraphQLSchema.Builder schemaBuilder) {
        GraphQLObjectType.Builder queryBuilder = GraphQLObjectType.newObject().name(QUERY).description(QUERY_DESCRIPTION);
        if (this.schema.hasQueries()) {
            this.addRootObject(queryBuilder, this.schema.getQueries(), QUERY);
        }
        if (this.schema.hasGroupedQueries()) {
            this.addGroupedRootObject(queryBuilder, this.schema.getGroupedQueries(), QUERY);
        }
        GraphQLObjectType query = queryBuilder.build();
        schemaBuilder.query(query);
    }

    private void addMutations(GraphQLSchema.Builder schemaBuilder) {
        GraphQLObjectType mutation;
        GraphQLObjectType.Builder mutationBuilder = GraphQLObjectType.newObject().name(MUTATION).description(MUTATION_DESCRIPTION);
        if (this.schema.hasMutations()) {
            this.addRootObject(mutationBuilder, this.schema.getMutations(), MUTATION);
        }
        if (this.schema.hasGroupedMutations()) {
            this.addGroupedRootObject(mutationBuilder, this.schema.getGroupedMutations(), MUTATION);
        }
        if ((mutation = mutationBuilder.build()).getFieldDefinitions() != null && !mutation.getFieldDefinitions().isEmpty()) {
            schemaBuilder.mutation(mutation);
        }
    }

    private void addSubscriptions(GraphQLSchema.Builder schemaBuilder) {
        GraphQLObjectType subscription;
        GraphQLObjectType.Builder subscriptionBuilder = GraphQLObjectType.newObject().name(SUBSCRIPTION).description(SUBSCRIPTION_DESCRIPTION);
        if (this.schema.hasSubscriptions()) {
            this.addRootObject(subscriptionBuilder, this.schema.getSubscriptions(), SUBSCRIPTION);
        }
        if (this.schema.hasGroupedSubscriptions()) {
            this.addGroupedRootObject(subscriptionBuilder, this.schema.getGroupedSubscriptions(), SUBSCRIPTION);
        }
        if ((subscription = subscriptionBuilder.build()).getFieldDefinitions() != null && !subscription.getFieldDefinitions().isEmpty()) {
            schemaBuilder.subscription(subscription);
        }
    }

    private void addRootObject(GraphQLObjectType.Builder rootBuilder, Set<Operation> operations, String rootName) {
        for (Operation operation : operations) {
            operation = this.eventEmitter.fireCreateOperation(operation);
            GraphQLFieldDefinition graphQLFieldDefinition = this.createGraphQLFieldDefinitionFromOperation(rootName, operation);
            rootBuilder.field(graphQLFieldDefinition);
        }
    }

    private void addGroupedRootObject(GraphQLObjectType.Builder rootBuilder, Map<Group, Set<Operation>> operationMap, String rootName) {
        Set<Map.Entry<Group, Set<Operation>>> operationsSet = operationMap.entrySet();
        for (Map.Entry<Group, Set<Operation>> operationsEntry : operationsSet) {
            Group group = operationsEntry.getKey();
            Set<Operation> operations = operationsEntry.getValue();
            GraphQLObjectType namedType = this.createNamedType(rootName, group, operations);
            GraphQLFieldDefinition.Builder graphQLFieldDefinitionBuilder = GraphQLFieldDefinition.newFieldDefinition().name(group.getName()).description(group.getDescription());
            graphQLFieldDefinitionBuilder.type((GraphQLOutputType)namedType);
            DataFetcher dummyDataFetcher = dfe -> namedType.getName();
            GraphQLFieldDefinition namedField = graphQLFieldDefinitionBuilder.build();
            this.codeRegistryBuilder.dataFetcherIfAbsent(FieldCoordinates.coordinates((String)rootName, (String)namedField.getName()), dummyDataFetcher);
            rootBuilder.field(namedField);
        }
    }

    private GraphQLObjectType createNamedType(String parent, Group group, Set<Operation> operations) {
        String namedTypeName = group.getName() + parent;
        GraphQLObjectType.Builder objectTypeBuilder = GraphQLObjectType.newObject().name(namedTypeName).description(group.getDescription());
        for (Operation operation : operations) {
            operation = this.eventEmitter.fireCreateOperation(operation);
            GraphQLFieldDefinition graphQLFieldDefinition = this.createGraphQLFieldDefinitionFromOperation(namedTypeName, operation);
            objectTypeBuilder = objectTypeBuilder.field(graphQLFieldDefinition);
        }
        return objectTypeBuilder.build();
    }

    private void createGraphQLEnumTypes() {
        if (this.schema.hasEnums()) {
            for (EnumType enumType : this.schema.getEnums().values()) {
                this.createGraphQLEnumType(enumType);
            }
        }
    }

    private void createGraphQLEnumType(EnumType enumType) {
        GraphQLEnumType.Builder enumBuilder = GraphQLEnumType.newEnum().name(enumType.getName()).description(enumType.getDescription());
        for (EnumValue value : enumType.getValues()) {
            enumBuilder = enumBuilder.value(value.getValue(), (Object)value.getValue(), value.getDescription());
        }
        GraphQLEnumType graphQLEnumType = enumBuilder.build();
        this.enumMap.put(enumType.getClassName(), graphQLEnumType);
    }

    private void createGraphQLInterfaceTypes() {
        if (this.schema.hasInterfaces()) {
            for (Type interfaceType : this.schema.getInterfaces().values()) {
                this.createGraphQLInterfaceType(interfaceType);
            }
        }
    }

    private void createGraphQLInterfaceType(Type interfaceType) {
        GraphQLInterfaceType.Builder interfaceTypeBuilder = GraphQLInterfaceType.newInterface().name(interfaceType.getName()).description(interfaceType.getDescription());
        if (interfaceType.hasFields()) {
            interfaceTypeBuilder = interfaceTypeBuilder.fields(this.createGraphQLFieldDefinitionsFromFields((Reference)interfaceType, interfaceType.getFields().values()));
        }
        if (interfaceType.hasInterfaces()) {
            Iterator interfaces = interfaceType.getInterfaces();
            Iterator iterator = interfaces.iterator();
            while (iterator.hasNext()) {
                Reference i = (Reference)iterator.next();
                interfaceTypeBuilder = interfaceTypeBuilder.withInterface(GraphQLTypeReference.typeRef((String)i.getName()));
            }
        }
        if (interfaceType.hasOperations()) {
            for (Operation operation : interfaceType.getOperations().values()) {
                String name = operation.getName();
                if (!interfaceType.hasBatchOperation(name)) {
                    operation = this.eventEmitter.fireCreateOperation(operation);
                    GraphQLFieldDefinition graphQLFieldDefinition = this.createGraphQLFieldDefinitionFromOperation(interfaceType.getName(), operation);
                    interfaceTypeBuilder = interfaceTypeBuilder.field(graphQLFieldDefinition);
                    continue;
                }
                SmallRyeGraphQLServerLogging.log.duplicateOperation(operation.getName());
            }
        }
        if (interfaceType.hasBatchOperations()) {
            for (Operation operation : interfaceType.getBatchOperations().values()) {
                operation = this.eventEmitter.fireCreateOperation(operation);
                GraphQLFieldDefinition graphQLFieldDefinition = this.createGraphQLFieldDefinitionFromBatchOperation(interfaceType.getName(), operation);
                interfaceTypeBuilder = interfaceTypeBuilder.field(graphQLFieldDefinition);
            }
        }
        GraphQLInterfaceType graphQLInterfaceType = interfaceTypeBuilder.build();
        this.codeRegistryBuilder.typeResolver(graphQLInterfaceType, (TypeResolver)new InterfaceResolver(interfaceType));
        this.interfaceMap.put(interfaceType.getName(), graphQLInterfaceType);
    }

    private void createGraphQLInputObjectTypes() {
        if (this.schema.hasInputs()) {
            for (InputType inputType : this.schema.getInputs().values()) {
                this.createGraphQLInputObjectType(inputType);
            }
        }
    }

    private void createGraphQLInputObjectType(InputType inputType) {
        GraphQLInputObjectType.Builder inputObjectTypeBuilder = GraphQLInputObjectType.newInputObject().name(inputType.getName()).description(inputType.getDescription());
        if (inputType.hasFields()) {
            inputObjectTypeBuilder = inputObjectTypeBuilder.fields(this.createGraphQLInputObjectFieldsFromFields(inputType.getFields().values()));
            JsonInputRegistry.register(inputType);
        }
        GraphQLInputObjectType graphQLInputObjectType = inputObjectTypeBuilder.build();
        this.inputMap.put(inputType.getName(), graphQLInputObjectType);
    }

    private void createGraphQLObjectTypes() {
        if (this.schema.hasTypes()) {
            for (Type type : this.schema.getTypes().values()) {
                this.createGraphQLObjectType(type);
            }
        }
    }

    private void createGraphQLObjectType(Type type) {
        GraphQLObjectType.Builder objectTypeBuilder = GraphQLObjectType.newObject().name(type.getName()).description(type.getDescription());
        if (type.hasDirectiveInstances()) {
            for (DirectiveInstance directiveInstance : type.getDirectiveInstances()) {
                objectTypeBuilder.withDirective(this.createGraphQLDirectiveFrom(directiveInstance));
            }
        }
        if (type.hasFields()) {
            objectTypeBuilder = objectTypeBuilder.fields(this.createGraphQLFieldDefinitionsFromFields((Reference)type, type.getFields().values()));
        }
        if (type.hasOperations()) {
            for (Operation operation : type.getOperations().values()) {
                String name = operation.getName();
                if (!type.hasBatchOperation(name)) {
                    operation = this.eventEmitter.fireCreateOperation(operation);
                    GraphQLFieldDefinition graphQLFieldDefinition = this.createGraphQLFieldDefinitionFromOperation(type.getName(), operation);
                    objectTypeBuilder = objectTypeBuilder.field(graphQLFieldDefinition);
                    continue;
                }
                SmallRyeGraphQLServerLogging.log.duplicateOperation(operation.getName());
            }
        }
        if (type.hasBatchOperations()) {
            for (Operation operation : type.getBatchOperations().values()) {
                operation = this.eventEmitter.fireCreateOperation(operation);
                GraphQLFieldDefinition graphQLFieldDefinition = this.createGraphQLFieldDefinitionFromBatchOperation(type.getName(), operation);
                objectTypeBuilder = objectTypeBuilder.field(graphQLFieldDefinition);
            }
        }
        if (type.hasInterfaces()) {
            Set interfaces = type.getInterfaces();
            for (Reference i : interfaces) {
                if (!this.interfaceMap.containsKey(i.getName())) continue;
                GraphQLInterfaceType graphQLInterfaceType = this.interfaceMap.get(i.getName());
                objectTypeBuilder = objectTypeBuilder.withInterface(graphQLInterfaceType);
            }
        }
        GraphQLObjectType graphQLObjectType = objectTypeBuilder.build();
        this.typeMap.put(type.getName(), graphQLObjectType);
        InterfaceOutputRegistry.register(type, graphQLObjectType);
    }

    private GraphQLDirective createGraphQLDirectiveFrom(DirectiveInstance directiveInstance) {
        DirectiveType directiveType = directiveInstance.getType();
        GraphQLDirective.Builder directive = GraphQLDirective.newDirective();
        directive.name(directiveType.getName());
        for (Map.Entry entry : directiveInstance.getValues().entrySet()) {
            String argumentName = (String)entry.getKey();
            DirectiveArgument argumentType = directiveType.getArgumentType(argumentName);
            directive.argument(GraphQLArgument.newArgument().type(this.argumentType(argumentType)).name(argumentName).value(entry.getValue()).build());
        }
        return directive.build();
    }

    private GraphQLFieldDefinition createGraphQLFieldDefinitionFromBatchOperation(String operationTypeName, Operation operation) {
        GraphQLFieldDefinition.Builder fieldBuilder = GraphQLFieldDefinition.newFieldDefinition().name(operation.getName()).description(operation.getDescription());
        fieldBuilder = fieldBuilder.type(this.createGraphQLOutputType((Field)operation, true));
        if (operation.hasArguments()) {
            fieldBuilder = fieldBuilder.arguments(this.createGraphQLArguments(operation.getArguments()));
        }
        BatchDataFetcher datafetcher = new BatchDataFetcher(operation);
        GraphQLFieldDefinition graphQLFieldDefinition = fieldBuilder.build();
        this.codeRegistryBuilder.dataFetcher(FieldCoordinates.coordinates((String)operationTypeName, (String)graphQLFieldDefinition.getName()), datafetcher);
        return graphQLFieldDefinition;
    }

    private GraphQLFieldDefinition createGraphQLFieldDefinitionFromOperation(String operationTypeName, Operation operation) {
        GraphQLFieldDefinition.Builder fieldBuilder = GraphQLFieldDefinition.newFieldDefinition().name(operation.getName()).description(operation.getDescription());
        fieldBuilder = fieldBuilder.type(this.createGraphQLOutputType((Field)operation, false));
        if (operation.hasArguments()) {
            fieldBuilder = fieldBuilder.arguments(this.createGraphQLArguments(operation.getArguments()));
        }
        GraphQLFieldDefinition graphQLFieldDefinition = fieldBuilder.build();
        DataFetcher datafetcher = this.dataFetcherFactory.getDataFetcher(operation);
        this.codeRegistryBuilder.dataFetcher(FieldCoordinates.coordinates((String)operationTypeName, (String)graphQLFieldDefinition.getName()), datafetcher);
        return graphQLFieldDefinition;
    }

    private List<GraphQLFieldDefinition> createGraphQLFieldDefinitionsFromFields(Reference owner, Collection<Field> fields) {
        ArrayList<GraphQLFieldDefinition> graphQLFieldDefinitions = new ArrayList<GraphQLFieldDefinition>();
        for (Field field : fields) {
            graphQLFieldDefinitions.add(this.createGraphQLFieldDefinitionFromField(owner, field));
        }
        return graphQLFieldDefinitions;
    }

    private GraphQLFieldDefinition createGraphQLFieldDefinitionFromField(Reference owner, Field field) {
        GraphQLFieldDefinition.Builder fieldBuilder = GraphQLFieldDefinition.newFieldDefinition().name(field.getName()).description(field.getDescription());
        fieldBuilder = fieldBuilder.type(this.createGraphQLOutputType(field, false));
        if (field.hasDirectiveInstances()) {
            for (DirectiveInstance directiveInstance : field.getDirectiveInstances()) {
                fieldBuilder.withDirective(this.createGraphQLDirectiveFrom(directiveInstance));
            }
        }
        GraphQLFieldDefinition graphQLFieldDefinition = fieldBuilder.build();
        FieldDataFetcher datafetcher = new FieldDataFetcher(field, owner);
        this.codeRegistryBuilder.dataFetcher(FieldCoordinates.coordinates((String)owner.getName(), (String)graphQLFieldDefinition.getName()), datafetcher);
        return graphQLFieldDefinition;
    }

    private List<GraphQLInputObjectField> createGraphQLInputObjectFieldsFromFields(Collection<Field> fields) {
        ArrayList<GraphQLInputObjectField> graphQLInputObjectFields = new ArrayList<GraphQLInputObjectField>();
        for (Field field : fields) {
            graphQLInputObjectFields.add(this.createGraphQLInputObjectFieldFromField(field));
        }
        return graphQLInputObjectFields;
    }

    private GraphQLInputObjectField createGraphQLInputObjectFieldFromField(Field field) {
        GraphQLInputObjectField.Builder inputFieldBuilder = GraphQLInputObjectField.newInputObjectField().name(field.getName()).description(field.getDescription());
        inputFieldBuilder = inputFieldBuilder.type(this.createGraphQLInputType(field));
        if (field.hasDefaultValue()) {
            inputFieldBuilder = inputFieldBuilder.defaultValue(this.sanitizeDefaultValue(field));
        }
        return inputFieldBuilder.build();
    }

    private GraphQLInputType createGraphQLInputType(Field field) {
        GraphQLInputType graphQLInputType = this.referenceGraphQLInputType(field);
        Wrapper wrapper = this.dataFetcherFactory.unwrap(field, false);
        if (wrapper != null && wrapper.isCollectionOrArray()) {
            if (wrapper.isNotEmpty()) {
                graphQLInputType = GraphQLNonNull.nonNull((GraphQLType)graphQLInputType);
            }
            do {
                if (wrapper.isCollectionOrArray()) {
                    graphQLInputType = GraphQLList.list((GraphQLType)graphQLInputType);
                    wrapper = wrapper.getWrapper();
                    continue;
                }
                wrapper = null;
            } while (wrapper != null);
        }
        if (field.isNotNull()) {
            graphQLInputType = GraphQLNonNull.nonNull((GraphQLType)graphQLInputType);
        }
        return graphQLInputType;
    }

    private GraphQLOutputType createGraphQLOutputType(Field field, boolean isBatch) {
        GraphQLOutputType graphQLOutputType = this.referenceGraphQLOutputType(field);
        Wrapper wrapper = this.dataFetcherFactory.unwrap(field, isBatch);
        if (wrapper != null && wrapper.isCollectionOrArray()) {
            if (wrapper.isNotEmpty()) {
                graphQLOutputType = GraphQLNonNull.nonNull((GraphQLType)graphQLOutputType);
            }
            do {
                if (wrapper.isCollectionOrArray()) {
                    graphQLOutputType = GraphQLList.list((GraphQLType)graphQLOutputType);
                    wrapper = wrapper.getWrapper();
                    continue;
                }
                wrapper = null;
            } while (wrapper != null);
        }
        if (field.isNotNull()) {
            graphQLOutputType = GraphQLNonNull.nonNull((GraphQLType)graphQLOutputType);
        }
        return graphQLOutputType;
    }

    private GraphQLOutputType referenceGraphQLOutputType(Field field) {
        Reference reference = this.getCorrectFieldReference(field);
        ReferenceType type = reference.getType();
        String className = reference.getClassName();
        String name = reference.getName();
        switch (type) {
            case SCALAR: {
                return this.getCorrectScalarType(reference);
            }
            case ENUM: {
                return (GraphQLOutputType)this.enumMap.get(className);
            }
        }
        return GraphQLTypeReference.typeRef((String)name);
    }

    private GraphQLInputType referenceGraphQLInputType(Field field) {
        Reference reference = this.getCorrectFieldReference(field);
        return this.getGraphQLInputType(reference);
    }

    private GraphQLInputType getGraphQLInputType(Reference reference) {
        ReferenceType type = reference.getType();
        String className = reference.getClassName();
        String name = reference.getName();
        switch (type) {
            case SCALAR: {
                return this.getCorrectScalarType(reference);
            }
            case ENUM: {
                return (GraphQLInputType)this.enumMap.get(className);
            }
        }
        return GraphQLTypeReference.typeRef((String)name);
    }

    private Reference getCorrectFieldReference(Field field) {
        if (field.getReference().hasMapping()) {
            return field.getReference().getMapping().getReference();
        }
        if (field.hasMapping()) {
            return field.getMapping().getReference();
        }
        return field.getReference();
    }

    private GraphQLScalarType getCorrectScalarType(Reference fieldReference) {
        return GraphQLScalarTypes.getScalarByName(fieldReference.getName());
    }

    private List<GraphQLArgument> createGraphQLArguments(List<Argument> arguments) {
        ArrayList<GraphQLArgument> graphQLArguments = new ArrayList<GraphQLArgument>();
        for (Argument argument : arguments) {
            if (argument.isSourceArgument() || IGNORABLE_ARGUMENTS.contains(argument.getReference().getClassName())) continue;
            graphQLArguments.add(this.createGraphQLArgument(argument));
        }
        return graphQLArguments;
    }

    private GraphQLArgument createGraphQLArgument(Argument argument) {
        GraphQLArgument.Builder argumentBuilder = GraphQLArgument.newArgument().name(argument.getName()).description(argument.getDescription());
        if (argument.hasDefaultValue()) {
            argumentBuilder = argumentBuilder.defaultValue(this.sanitizeDefaultValue((Field)argument));
        }
        GraphQLInputType graphQLInputType = this.referenceGraphQLInputType((Field)argument);
        Wrapper wrapper = this.dataFetcherFactory.unwrap((Field)argument, false);
        if (wrapper != null && wrapper.isCollectionOrArray()) {
            if (wrapper.isNotEmpty()) {
                graphQLInputType = GraphQLNonNull.nonNull((GraphQLType)graphQLInputType);
            }
            do {
                if (wrapper.isCollectionOrArray()) {
                    graphQLInputType = GraphQLList.list((GraphQLType)graphQLInputType);
                    wrapper = wrapper.getWrapper();
                    continue;
                }
                wrapper = null;
            } while (wrapper != null);
        }
        if (argument.isNotNull()) {
            graphQLInputType = GraphQLNonNull.nonNull((GraphQLType)graphQLInputType);
        }
        argumentBuilder = argumentBuilder.type(graphQLInputType);
        return argumentBuilder.build();
    }

    private Object sanitizeDefaultValue(Field field) {
        String jsonString = field.getDefaultValue();
        if (jsonString == null) {
            return null;
        }
        if (this.isJsonString(jsonString)) {
            Class<?> type;
            Wrapper wrapper = this.dataFetcherFactory.unwrap(field, false);
            if (wrapper != null && wrapper.isCollectionOrArray()) {
                type = this.classloadingService.loadClass(field.getWrapper().getWrapperClassName());
                if (Collection.class.isAssignableFrom(type)) {
                    type = CollectionCreator.newCollection(field.getWrapper().getWrapperClassName(), 0).getClass();
                }
            } else {
                type = this.classloadingService.loadClass(field.getReference().getClassName());
            }
            Jsonb jsonB = JsonBCreator.getJsonB(type.getName());
            Reference reference = this.getCorrectFieldReference(field);
            ReferenceType referenceType = reference.getType();
            if (referenceType.equals((Object)ReferenceType.INPUT) || referenceType.equals((Object)ReferenceType.TYPE)) {
                return jsonB.fromJson(jsonString, Map.class);
            }
            return jsonB.fromJson(jsonString, type);
        }
        if (Classes.isNumberLikeType(field.getReference().getGraphQlClassName())) {
            return new BigDecimal(jsonString);
        }
        if (Classes.isBoolean(field.getReference().getGraphQlClassName())) {
            return Boolean.parseBoolean(jsonString);
        }
        return jsonString;
    }

    /*
     * Exception decompiling
     */
    private boolean isJsonString(String string) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private GraphqlFieldVisibility getGraphqlFieldVisibility() {
        Config config = Config.get();
        String fieldVisibility = config.getFieldVisibility();
        if (fieldVisibility != null && !fieldVisibility.isEmpty()) {
            if (fieldVisibility.equals("no-introspection")) {
                return NoIntrospectionGraphqlFieldVisibility.NO_INTROSPECTION_FIELD_VISIBILITY;
            }
            String[] patterns = fieldVisibility.split(COMMA);
            BlockedFields.Builder blockedFields = BlockedFields.newBlock();
            for (String pattern : patterns) {
                blockedFields = blockedFields.addPattern(pattern);
            }
            return blockedFields.build();
        }
        return DefaultGraphqlFieldVisibility.DEFAULT_FIELD_VISIBILITY;
    }
}

