/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.datafetcher;

import graphql.GraphQLContext;
import graphql.execution.DataFetcherResult;
import graphql.schema.DataFetchingEnvironment;
import io.smallrye.graphql.SmallRyeGraphQLServerMessages;
import io.smallrye.graphql.execution.context.SmallRyeContext;
import io.smallrye.graphql.execution.datafetcher.AbstractDataFetcher;
import io.smallrye.graphql.schema.model.Operation;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.dataloader.BatchLoaderEnvironment;
import org.eclipse.microprofile.context.ThreadContext;

public class DefaultDataFetcher<K, T>
extends AbstractDataFetcher<K, T> {
    public DefaultDataFetcher(Operation operation) {
        super(operation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T invokeAndTransform(DataFetchingEnvironment dfe, DataFetcherResult.Builder<Object> resultBuilder, Object[] transformedArguments) throws Exception {
        SmallRyeContext context = (SmallRyeContext)((GraphQLContext)dfe.getContext()).get((Object)"context");
        try {
            SmallRyeContext.setContext(context);
            Object resultFromMethodCall = this.reflectionHelper.invoke(transformedArguments);
            Object resultFromTransform = this.fieldHelper.transformResponse(resultFromMethodCall);
            resultBuilder.data(resultFromTransform);
            DataFetcherResult dataFetcherResult = resultBuilder.build();
            return (T)dataFetcherResult;
        }
        finally {
            SmallRyeContext.remove();
        }
    }

    @Override
    public <T> T invokeFailure(DataFetcherResult.Builder<Object> resultBuilder) {
        return (T)resultBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletionStage<List<T>> load(List<K> keys, BatchLoaderEnvironment ble) {
        Object[] arguments = this.batchLoaderHelper.getArguments(keys, ble);
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        SmallRyeContext context = (SmallRyeContext)ble.getContext();
        ThreadContext threadContext = ThreadContext.builder().build();
        try {
            SmallRyeContext.setContext(context);
            CompletableFuture<List> reflectionSupplier = CompletableFuture.supplyAsync(() -> {
                try {
                    return (List)this.reflectionHelper.invokePrivileged(tccl, arguments);
                }
                catch (Exception e) {
                    if (e instanceof RuntimeException && e.getCause() != null && !(e.getCause() instanceof RuntimeException)) {
                        throw SmallRyeGraphQLServerMessages.msg.dataFetcherException(this.operation, e.getCause());
                    }
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw SmallRyeGraphQLServerMessages.msg.dataFetcherException(this.operation, e);
                }
            }, threadContext.currentContextExecutor());
            CompletableFuture completableFuture = threadContext.withContextCapture(reflectionSupplier);
            return completableFuture;
        }
        finally {
            SmallRyeContext.remove();
        }
    }
}

