/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.datafetcher.helper;

import graphql.GraphQLError;
import graphql.execution.DataFetcherExceptionHandlerParameters;
import graphql.execution.DataFetcherExceptionHandlerResult;
import graphql.execution.DataFetcherResult;
import graphql.execution.ResultPath;
import graphql.language.SourceLocation;
import graphql.schema.DataFetchingEnvironment;
import io.smallrye.graphql.execution.error.ExceptionHandler;
import io.smallrye.graphql.execution.error.GraphQLExceptionWhileDataFetching;
import java.util.List;
import org.eclipse.microprofile.graphql.GraphQLException;

public class ErrorResultHelper {
    private final ExceptionHandler exceptionHandler = new ExceptionHandler();

    public void appendPartialResult(DataFetcherResult.Builder<Object> resultBuilder, DataFetchingEnvironment dfe, GraphQLException graphQLException) {
        DataFetcherExceptionHandlerParameters handlerParameters = DataFetcherExceptionHandlerParameters.newExceptionParameters().dataFetchingEnvironment(dfe).exception((Throwable)graphQLException).build();
        SourceLocation sourceLocation = handlerParameters.getSourceLocation();
        ResultPath path = handlerParameters.getPath();
        GraphQLExceptionWhileDataFetching error = new GraphQLExceptionWhileDataFetching(path, graphQLException, sourceLocation);
        resultBuilder.data(graphQLException.getPartialResults()).error((GraphQLError)error);
    }

    public List<GraphQLError> toGraphQLErrors(DataFetchingEnvironment dfe, Throwable t) {
        DataFetcherExceptionHandlerParameters handlerParameters = DataFetcherExceptionHandlerParameters.newExceptionParameters().dataFetchingEnvironment(dfe).exception(t).build();
        DataFetcherExceptionHandlerResult exceptionHandlerResult = this.exceptionHandler.onException(handlerParameters);
        return exceptionHandlerResult.getErrors();
    }

    public void appendException(DataFetcherResult.Builder<Object> resultBuilder, DataFetchingEnvironment dfe, Throwable t) {
        resultBuilder.errors(this.toGraphQLErrors(dfe, t));
    }
}

