/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.bootstrap;

import graphql.schema.DataFetcher;
import io.smallrye.graphql.execution.datafetcher.CompletionStageDataFetcher;
import io.smallrye.graphql.execution.datafetcher.DefaultDataFetcher;
import io.smallrye.graphql.execution.datafetcher.MultiDataFetcher;
import io.smallrye.graphql.execution.datafetcher.PublisherDataFetcher;
import io.smallrye.graphql.execution.datafetcher.UniDataFetcher;
import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.schema.model.Wrapper;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.dataloader.BatchLoaderWithContext;

public class DataFetcherFactory {
    public <T> DataFetcher<T> getDataFetcher(Operation operation) {
        return (DataFetcher)this.get(operation);
    }

    public <K, T> BatchLoaderWithContext<K, T> getSourceBatchLoader(Operation operation) {
        return (BatchLoaderWithContext)this.get(operation);
    }

    public Wrapper unwrap(Field field, boolean isBatch) {
        if (this.isAsync(field) && isBatch) {
            return field.getWrapper().getWrapper().getWrapper();
        }
        if (this.isAsync(field)) {
            return field.getWrapper().getWrapper();
        }
        if (isBatch) {
            return field.getWrapper().getWrapper();
        }
        if (field.hasWrapper() && field.getWrapper().isCollectionOrArrayOrMap()) {
            return field.getWrapper();
        }
        if (field.hasWrapper()) {
            // empty if block
        }
        return null;
    }

    private <V> V get(Operation operation) {
        if (this.isCompletionStage((Field)operation)) {
            return (V)new CompletionStageDataFetcher(operation);
        }
        if (this.isMutinyUni((Field)operation)) {
            return (V)new UniDataFetcher(operation);
        }
        if (this.isPublisher((Field)operation)) {
            return (V)new PublisherDataFetcher(operation);
        }
        if (this.isMutinyMulti((Field)operation)) {
            return (V)new MultiDataFetcher(operation);
        }
        return (V)new DefaultDataFetcher(operation);
    }

    private boolean isAsync(Field field) {
        return this.isCompletionStage(field) || this.isMutinyUni(field);
    }

    private boolean isCompletionStage(Field field) {
        if (field.hasWrapper()) {
            String wrapperClassName = field.getWrapper().getWrapperClassName();
            return wrapperClassName.equals(CompletableFuture.class.getName()) || wrapperClassName.equals(CompletionStage.class.getName());
        }
        return false;
    }

    private boolean isMutinyUni(Field field) {
        if (field.hasWrapper()) {
            String wrapperClassName = field.getWrapper().getWrapperClassName();
            return wrapperClassName.equals("io.smallrye.mutiny.Uni");
        }
        return false;
    }

    private boolean isPublisher(Field field) {
        if (field.hasWrapper()) {
            String wrapperClassName = field.getWrapper().getWrapperClassName();
            return wrapperClassName.equals("org.reactivestreams.Publisher");
        }
        return false;
    }

    private boolean isMutinyMulti(Field field) {
        if (field.hasWrapper()) {
            String wrapperClassName = field.getWrapper().getWrapperClassName();
            return wrapperClassName.equals("io.smallrye.mutiny.Multi");
        }
        return false;
    }
}

