/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.datafetcher;

import graphql.GraphQLContext;
import graphql.execution.DataFetcherResult;
import graphql.schema.DataFetchingEnvironment;
import io.smallrye.graphql.SmallRyeGraphQLServerMessages;
import io.smallrye.graphql.execution.context.SmallRyeContext;
import io.smallrye.graphql.execution.datafetcher.AbstractDataFetcher;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.transformation.AbstractDataFetcherException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.dataloader.BatchLoaderEnvironment;
import org.eclipse.microprofile.context.ThreadContext;
import org.eclipse.microprofile.graphql.GraphQLException;

public class CompletionStageDataFetcher<K, T>
extends AbstractDataFetcher<K, T> {
    public CompletionStageDataFetcher(Operation operation) {
        super(operation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <T> T invokeAndTransform(DataFetchingEnvironment dfe, DataFetcherResult.Builder<Object> resultBuilder, Object[] transformedArguments) throws AbstractDataFetcherException, Exception {
        SmallRyeContext context = (SmallRyeContext)((GraphQLContext)dfe.getContext()).get((Object)"context");
        ThreadContext threadContext = ThreadContext.builder().build();
        SmallRyeContext.setContext(context);
        try {
            CompletableFuture futureResultFromMethodCall = threadContext.withContextCapture((CompletableFuture)this.operationInvoker.invoke(transformedArguments));
            CompletionStage<DataFetcherResult> completionStage = futureResultFromMethodCall.handle((result, throwable) -> {
                if (throwable != null) {
                    this.eventEmitter.fireOnDataFetchError(dfe.getExecutionId().toString(), (Throwable)throwable);
                    if (throwable instanceof GraphQLException) {
                        GraphQLException graphQLException = (GraphQLException)throwable;
                        this.errorResultHelper.appendPartialResult(resultBuilder, dfe, graphQLException);
                    } else {
                        if (throwable instanceof Exception) {
                            throw SmallRyeGraphQLServerMessages.msg.dataFetcherException(this.operation, (Throwable)throwable);
                        }
                        if (throwable instanceof Error) {
                            throw (Error)throwable;
                        }
                    }
                } else {
                    try {
                        resultBuilder.data(this.fieldHelper.transformOrAdaptResponse(result, dfe));
                    }
                    catch (AbstractDataFetcherException te) {
                        te.appendDataFetcherResult(resultBuilder, dfe);
                    }
                }
                return resultBuilder.build();
            });
            return (T)completionStage;
        }
        finally {
            SmallRyeContext.remove();
        }
    }

    @Override
    protected <T> T invokeFailure(DataFetcherResult.Builder<Object> resultBuilder) {
        return (T)CompletableFuture.completedFuture(resultBuilder.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletionStage<List<T>> load(List<K> keys, BatchLoaderEnvironment ble) {
        Object[] arguments = this.batchLoaderHelper.getArguments(keys, ble);
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        SmallRyeContext context = (SmallRyeContext)ble.getContext();
        ThreadContext threadContext = ThreadContext.builder().build();
        try {
            SmallRyeContext.setContext(context);
            CompletableFuture completableFuture = threadContext.withContextCapture((CompletableFuture)this.operationInvoker.invokePrivileged(tccl, arguments));
            return completableFuture;
        }
        finally {
            SmallRyeContext.remove();
        }
    }
}

