/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution;

import graphql.ExecutionInput;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.SimpleInstrumentation;
import graphql.execution.instrumentation.parameters.InstrumentationValidationParameters;
import graphql.execution.preparsed.PreparsedDocumentEntry;
import graphql.execution.preparsed.PreparsedDocumentProvider;
import graphql.validation.ValidationError;
import io.smallrye.graphql.SmallRyeGraphQLServerLogging;
import io.smallrye.graphql.execution.LRUCache;
import java.security.AccessController;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class QueryCache
extends SimpleInstrumentation
implements PreparsedDocumentProvider {
    private static final int MAX_CACHE_SIZE = AccessController.doPrivileged(() -> Integer.getInteger("io.smallrye.graphql.execution.queryCacheMaxSize", 2048));
    private static final ThreadLocal<ExecutionFunction> executionFunctionTL = new ThreadLocal();
    private final LRUCache<String, PreparsedDocumentEntry> cache = new LRUCache(MAX_CACHE_SIZE);

    public PreparsedDocumentEntry getDocument(ExecutionInput executionInput, Function<ExecutionInput, PreparsedDocumentEntry> computeFunction) {
        String query = executionInput.getQuery();
        PreparsedDocumentEntry entry = this.cache.get(query);
        if (entry == null) {
            ExecutionFunction executionFunction = new ExecutionFunction(computeFunction, executionInput);
            executionFunctionTL.set(executionFunction);
            entry = computeFunction.apply(executionInput);
        } else {
            SmallRyeGraphQLServerLogging.log.retrievedFromCache(query);
        }
        return entry;
    }

    public InstrumentationContext<List<ValidationError>> beginValidation(InstrumentationValidationParameters parameters) {
        ExecutionFunction executionFunction = executionFunctionTL.get();
        executionFunctionTL.remove();
        if (executionFunction != null) {
            return new ValidationInstrumentationContext(executionFunction);
        }
        return super.beginValidation(parameters);
    }

    private class ValidationInstrumentationContext
    implements InstrumentationContext<List<ValidationError>> {
        private final ExecutionFunction executionFunction;

        ValidationInstrumentationContext(ExecutionFunction executionFunction) {
            this.executionFunction = executionFunction;
        }

        public void onDispatched(CompletableFuture<List<ValidationError>> result) {
        }

        public void onCompleted(List<ValidationError> validationErrors, Throwable t) {
            if (t == null && (validationErrors == null || validationErrors.isEmpty())) {
                QueryCache.this.cache.computeIfAbsent(this.executionFunction.getQuery(), this.executionFunction);
                SmallRyeGraphQLServerLogging.log.addedToCache(this.executionFunction.getQuery());
            }
        }
    }

    private static class ExecutionFunction
    implements Function<String, PreparsedDocumentEntry> {
        private final Function<ExecutionInput, PreparsedDocumentEntry> function;
        private final ExecutionInput executionInput;

        ExecutionFunction(Function<ExecutionInput, PreparsedDocumentEntry> function, ExecutionInput executionInput) {
            this.function = function;
            this.executionInput = executionInput;
        }

        @Override
        public PreparsedDocumentEntry apply(String s) {
            return this.function.apply(this.executionInput);
        }

        String getQuery() {
            return this.executionInput.getQuery();
        }
    }
}

