/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.datafetcher;

import graphql.GraphQLContext;
import graphql.GraphQLException;
import graphql.TrivialDataFetcher;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import io.smallrye.graphql.SmallRyeGraphQLServerLogging;
import io.smallrye.graphql.execution.context.SmallRyeContext;
import io.smallrye.graphql.execution.datafetcher.helper.FieldHelper;
import io.smallrye.graphql.schema.model.Reference;
import io.smallrye.graphql.spi.ClassloadingService;
import io.smallrye.graphql.transformation.AbstractDataFetcherException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class FieldDataFetcher<T>
implements DataFetcher<T>,
TrivialDataFetcher<T> {
    private final FieldHelper fieldHelper;
    private final io.smallrye.graphql.schema.model.Field field;
    private final Reference owner;
    private PropertyAccessor<Object> propertyAccessor;

    public FieldDataFetcher(io.smallrye.graphql.schema.model.Field field, Reference owner) {
        this.fieldHelper = new FieldHelper(field);
        this.field = field;
        this.owner = owner;
    }

    public T get(DataFetchingEnvironment dfe) throws Exception {
        if (dfe.getContext() != null) {
            GraphQLContext graphQLContext = (GraphQLContext)dfe.getContext();
            graphQLContext.put((Object)"context", (Object)((SmallRyeContext)graphQLContext.get((Object)"context")).withDataFromFetcher(dfe, this.field));
        }
        if (this.propertyAccessor == null) {
            this.propertyAccessor = this.buildPropertyAccessor();
        }
        Object source = dfe.getSource();
        Object resultFromMethodCall = this.propertyAccessor.get(source);
        try {
            Object transformResponse = this.fieldHelper.transformOrAdaptResponse(resultFromMethodCall, dfe);
            return (T)transformResponse;
        }
        catch (AbstractDataFetcherException ex) {
            SmallRyeGraphQLServerLogging.log.transformError(ex);
            Object result = resultFromMethodCall;
            return (T)result;
        }
    }

    private PropertyAccessor<Object> buildPropertyAccessor() {
        try {
            Class<?> aClass = ClassloadingService.get().loadClass(this.owner.getClassName());
            if (this.field.getMethodName() == null) {
                return new FieldAccessor<Object>(aClass.getField(this.field.getPropertyName()));
            }
            return new MethodAccessor<Object>(aClass.getMethod(this.field.getMethodName(), new Class[0]));
        }
        catch (ReflectiveOperationException e) {
            throw new GraphQLException((Throwable)e);
        }
    }

    static class MethodAccessor<T>
    implements PropertyAccessor<T> {
        private final Method method;

        MethodAccessor(Method method) {
            this.method = method;
        }

        @Override
        public T get(Object source) throws InvocationTargetException, IllegalAccessException {
            Object result = this.method.invoke(source, new Object[0]);
            return (T)result;
        }
    }

    static class FieldAccessor<T>
    implements PropertyAccessor<T> {
        private final Field field;

        FieldAccessor(Field field) {
            this.field = field;
        }

        @Override
        public T get(Object source) throws IllegalAccessException {
            Object result = this.field.get(source);
            return (T)result;
        }
    }

    static interface PropertyAccessor<T> {
        public T get(Object var1) throws ReflectiveOperationException;
    }
}

