/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.datafetcher;

import graphql.GraphQLContext;
import graphql.execution.DataFetcherResult;
import graphql.schema.DataFetchingEnvironment;
import io.smallrye.graphql.SmallRyeGraphQLServerMessages;
import io.smallrye.graphql.execution.context.SmallRyeContext;
import io.smallrye.graphql.execution.datafetcher.AbstractDataFetcher;
import io.smallrye.graphql.execution.datafetcher.DataFetcherException;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.transformation.AbstractDataFetcherException;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.dataloader.BatchLoaderEnvironment;
import org.eclipse.microprofile.graphql.GraphQLException;

public class MultiDataFetcher<K, T>
extends AbstractDataFetcher<K, T> {
    public MultiDataFetcher(Operation operation) {
        super(operation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <O> O invokeAndTransform(final DataFetchingEnvironment dfe, final DataFetcherResult.Builder<Object> resultBuilder, Object[] transformedArguments) throws Exception {
        SmallRyeContext context = (SmallRyeContext)((GraphQLContext)dfe.getContext()).get((Object)"context");
        try {
            SmallRyeContext.setContext(context);
            Multi multi = (Multi)this.operationInvoker.invoke(transformedArguments);
            Multi multi2 = multi.onItem().transform(t -> {
                try {
                    Object resultFromTransform = this.fieldHelper.transformOrAdaptResponse(t, dfe);
                    resultBuilder.data(resultFromTransform);
                    return resultBuilder.build();
                }
                catch (AbstractDataFetcherException abstractDataFetcherException) {
                    abstractDataFetcherException.appendDataFetcherResult(resultBuilder, dfe);
                    this.eventEmitter.fireOnDataFetchError(dfe.getExecutionId().toString(), abstractDataFetcherException);
                    return resultBuilder.build();
                }
            }).onFailure().recoverWithItem(new Function<Throwable, O>(){

                @Override
                public O apply(Throwable throwable) {
                    MultiDataFetcher.this.eventEmitter.fireOnDataFetchError(dfe.getExecutionId().toString(), throwable);
                    if (throwable instanceof GraphQLException) {
                        GraphQLException graphQLException = (GraphQLException)throwable;
                        MultiDataFetcher.this.errorResultHelper.appendPartialResult((DataFetcherResult.Builder<Object>)resultBuilder, dfe, graphQLException);
                    } else if (throwable instanceof Exception) {
                        DataFetcherException dataFetcherException = SmallRyeGraphQLServerMessages.msg.dataFetcherException(MultiDataFetcher.this.operation, throwable);
                        MultiDataFetcher.this.errorResultHelper.appendException((DataFetcherResult.Builder<Object>)resultBuilder, dfe, dataFetcherException);
                    } else if (throwable instanceof Error) {
                        MultiDataFetcher.this.errorResultHelper.appendException((DataFetcherResult.Builder<Object>)resultBuilder, dfe, throwable);
                    }
                    return resultBuilder.build();
                }
            });
            return (O)multi2;
        }
        finally {
            SmallRyeContext.remove();
        }
    }

    @Override
    protected <O> O invokeFailure(DataFetcherResult.Builder<Object> resultBuilder) {
        return (O)Multi.createFrom().item(() -> resultBuilder.build());
    }

    public CompletionStage<List<T>> load(List<K> keys, BatchLoaderEnvironment ble) {
        Object[] arguments = this.batchLoaderHelper.getArguments(keys, ble);
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        return ((Multi)this.operationInvoker.invokePrivileged(tccl, arguments)).toUni().runSubscriptionOn(Infrastructure.getDefaultExecutor()).subscribe().asCompletionStage();
    }
}

