/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.error;

import graphql.ExceptionWhileDataFetching;
import graphql.GraphQLError;
import graphql.validation.ValidationError;
import io.smallrye.graphql.execution.error.ErrorInfoMap;
import io.smallrye.graphql.schema.model.ErrorInfo;
import io.smallrye.graphql.spi.config.Config;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReaderFactory;
import javax.json.JsonValue;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.JsonbConfig;

public class ExecutionErrorsService {
    private static final JsonBuilderFactory jsonBuilderFactory = Json.createBuilderFactory(null);
    private static final JsonReaderFactory jsonReaderFactory = Json.createReaderFactory(null);
    private static final Jsonb JSONB = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withNullValues(Boolean.TRUE).withFormatting(Boolean.TRUE));
    private Config config = Config.get();
    private static final String EXTENSIONS = "extensions";

    public JsonArray toJsonErrors(List<GraphQLError> errors) {
        JsonArrayBuilder arrayBuilder = jsonBuilderFactory.createArrayBuilder();
        for (GraphQLError e : errors) {
            arrayBuilder.add((JsonValue)this.toJsonError(e));
        }
        return arrayBuilder.build();
    }

    /*
     * Exception decompiling
     */
    private JsonObject toJsonError(GraphQLError error) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Optional<JsonObject> getOptionalExtensions(GraphQLError error) {
        if (error instanceof ValidationError) {
            return this.getValidationExtensions((ValidationError)error);
        }
        if (error instanceof ExceptionWhileDataFetching) {
            return this.getDataFetchingExtensions((ExceptionWhileDataFetching)error);
        }
        return Optional.empty();
    }

    private Optional<JsonObject> getValidationExtensions(ValidationError error) {
        if (this.config.getErrorExtensionFields().isPresent()) {
            JsonObjectBuilder objectBuilder = jsonBuilderFactory.createObjectBuilder();
            this.addKeyValue(objectBuilder, "description", error.getDescription());
            this.addKeyValue(objectBuilder, "validationErrorType", error.getValidationErrorType().toString());
            objectBuilder.add("queryPath", (JsonValue)this.toJsonArray(error.getQueryPath()));
            this.addKeyValue(objectBuilder, "classification", error.getErrorType().toString());
            Map extensions = error.getExtensions();
            this.populateCustomExtensions(objectBuilder, extensions);
            return Optional.of(objectBuilder.build());
        }
        return Optional.empty();
    }

    private Optional<JsonObject> getDataFetchingExtensions(ExceptionWhileDataFetching error) {
        if (this.config.getErrorExtensionFields().isPresent()) {
            Throwable exception = error.getException();
            JsonObjectBuilder objectBuilder = jsonBuilderFactory.createObjectBuilder();
            this.addKeyValue(objectBuilder, "exception", exception.getClass().getName());
            this.addKeyValue(objectBuilder, "classification", error.getErrorType().toString());
            this.addKeyValue(objectBuilder, "code", this.toErrorCode(exception));
            Map extensions = error.getExtensions();
            this.populateCustomExtensions(objectBuilder, extensions);
            return Optional.of(objectBuilder.build());
        }
        return Optional.empty();
    }

    private String toErrorCode(Throwable exception) {
        String exceptionClassName = exception.getClass().getName();
        if (ErrorInfoMap.hasErrorInfo(exceptionClassName)) {
            ErrorInfo errorInfo = ErrorInfoMap.getErrorInfo(exceptionClassName);
            return errorInfo.getErrorCode();
        }
        return ExecutionErrorsService.camelToKebab(exception.getClass().getSimpleName().replaceAll("Exception$", ""));
    }

    private static String camelToKebab(String input) {
        return String.join((CharSequence)"-", input.split("(?=\\p{javaUpperCase})")).toLowerCase(Locale.UK);
    }

    private void populateCustomExtensions(JsonObjectBuilder objectBuilder, Map<String, Object> extensions) {
        if (extensions != null) {
            for (Map.Entry<String, Object> entry : extensions.entrySet()) {
                if (this.config.getErrorExtensionFields().isPresent() && (!this.config.getErrorExtensionFields().isPresent() || !this.config.getErrorExtensionFields().get().contains(entry.getKey()))) continue;
                this.addKeyValue(objectBuilder, entry.getKey(), entry.getValue().toString());
            }
        }
    }

    private JsonArray toJsonArray(List<?> list) {
        JsonArrayBuilder arrayBuilder = jsonBuilderFactory.createArrayBuilder();
        if (list != null && !list.isEmpty()) {
            for (Object o : list) {
                if (o == null) continue;
                arrayBuilder.add(o.toString());
            }
        }
        return arrayBuilder.build();
    }

    private void addKeyValue(JsonObjectBuilder objectBuilder, String key, String value) {
        if (this.config.getErrorExtensionFields().isPresent()) {
            List<String> fieldsThatShouldBeIncluded = this.config.getErrorExtensionFields().get();
            if (fieldsThatShouldBeIncluded.contains(key)) {
                objectBuilder.add(key, value);
            }
        } else if (value != null) {
            objectBuilder.add(key, value);
        }
    }

    private static /* synthetic */ void lambda$toJsonError$0(JsonObjectBuilder resultBuilder, JsonObject jsonObject) {
        resultBuilder.add(EXTENSIONS, (JsonValue)jsonObject);
    }
}

