/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.bootstrap;

import graphql.schema.DataFetcher;
import io.smallrye.graphql.execution.datafetcher.CompletionStageDataFetcher;
import io.smallrye.graphql.execution.datafetcher.DefaultDataFetcher;
import io.smallrye.graphql.execution.datafetcher.MultiDataFetcher;
import io.smallrye.graphql.execution.datafetcher.PlugableDataFetcher;
import io.smallrye.graphql.execution.datafetcher.PublisherDataFetcher;
import io.smallrye.graphql.execution.datafetcher.UniDataFetcher;
import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.schema.model.Wrapper;
import io.smallrye.graphql.spi.DataFetcherService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.dataloader.BatchLoaderWithContext;

public class DataFetcherFactory {
    private List<DataFetcherService> dataFetcherServices = new ArrayList<DataFetcherService>();

    public DataFetcherFactory() {
        Iterator<DataFetcherService> i = ServiceLoader.load(DataFetcherService.class).iterator();
        while (i.hasNext()) {
            this.dataFetcherServices.add(i.next());
        }
        Collections.sort(this.dataFetcherServices, new Comparator<DataFetcherService>(){

            @Override
            public int compare(DataFetcherService o1, DataFetcherService o2) {
                return o1.getPriority().compareTo(o2.getPriority());
            }
        });
    }

    public <T> DataFetcher<T> getDataFetcher(Operation operation) {
        return (DataFetcher)this.get(operation);
    }

    public <K, T> BatchLoaderWithContext<K, T> getSourceBatchLoader(Operation operation) {
        return (BatchLoaderWithContext)this.get(operation);
    }

    public Wrapper unwrap(Field field, boolean isBatch) {
        if (this.isAsync(field) && isBatch) {
            return field.getWrapper().getWrapper().getWrapper();
        }
        if (this.isAsync(field)) {
            return field.getWrapper().getWrapper();
        }
        if (isBatch) {
            return field.getWrapper().getWrapper();
        }
        if (field.hasWrapper() && field.getWrapper().isCollectionOrArrayOrMap()) {
            return field.getWrapper();
        }
        if (field.hasWrapper()) {
            // empty if block
        }
        return null;
    }

    private <V> V get(Operation operation) {
        if (this.isCompletionStage((Field)operation)) {
            return (V)this.getCompletionStageDataFetcher(operation);
        }
        if (this.isMutinyUni((Field)operation)) {
            return (V)this.getUniDataFetcher(operation);
        }
        if (this.isPublisher((Field)operation)) {
            return (V)this.getPublisherDataFetcher(operation);
        }
        if (this.isMutinyMulti((Field)operation)) {
            return (V)this.getMultiDataFetcher(operation);
        }
        if (this.isWrapped((Field)operation)) {
            return (V)this.getOtherWrappedDataFetcher(operation);
        }
        return (V)this.getOtherFieldDataFetcher(operation);
    }

    public PlugableDataFetcher getCompletionStageDataFetcher(Operation operation) {
        for (DataFetcherService dfe : this.dataFetcherServices) {
            PlugableDataFetcher df = dfe.getCompletionStageDataFetcher(operation);
            if (df == null) continue;
            return df;
        }
        return new CompletionStageDataFetcher(operation);
    }

    public PlugableDataFetcher getUniDataFetcher(Operation operation) {
        for (DataFetcherService dfe : this.dataFetcherServices) {
            PlugableDataFetcher df = dfe.getUniDataFetcher(operation);
            if (df == null) continue;
            return df;
        }
        return new UniDataFetcher(operation);
    }

    public PlugableDataFetcher getPublisherDataFetcher(Operation operation) {
        for (DataFetcherService dfe : this.dataFetcherServices) {
            PlugableDataFetcher df = dfe.getPublisherDataFetcher(operation);
            if (df == null) continue;
            return df;
        }
        return new PublisherDataFetcher(operation);
    }

    public PlugableDataFetcher getMultiDataFetcher(Operation operation) {
        for (DataFetcherService dfe : this.dataFetcherServices) {
            PlugableDataFetcher df = dfe.getMultiDataFetcher(operation);
            if (df == null) continue;
            return df;
        }
        return new MultiDataFetcher(operation);
    }

    public PlugableDataFetcher getOtherWrappedDataFetcher(Operation operation) {
        for (DataFetcherService dfe : this.dataFetcherServices) {
            PlugableDataFetcher df = dfe.getOtherWrappedDataFetcher(operation);
            if (df == null) continue;
            return df;
        }
        return this.getDefaultDataFetcher(operation);
    }

    public PlugableDataFetcher getOtherFieldDataFetcher(Operation operation) {
        PlugableDataFetcher df;
        for (DataFetcherService dfe : this.dataFetcherServices) {
            df = dfe.getOtherFieldDataFetcher(operation);
            if (df == null) continue;
            return df;
        }
        for (DataFetcherService dfe : this.dataFetcherServices) {
            df = dfe.getDefaultDataFetcher(operation);
            if (df == null) continue;
            return df;
        }
        return new DefaultDataFetcher(operation);
    }

    public PlugableDataFetcher getDefaultDataFetcher(Operation operation) {
        return this.getOtherFieldDataFetcher(operation);
    }

    private boolean isAsync(Field field) {
        return this.isCompletionStage(field) || this.isMutinyUni(field);
    }

    private boolean isWrapped(Field field) {
        return field.hasWrapper();
    }

    private boolean isCompletionStage(Field field) {
        if (field.hasWrapper()) {
            String wrapperClassName = field.getWrapper().getWrapperClassName();
            return wrapperClassName.equals(CompletableFuture.class.getName()) || wrapperClassName.equals(CompletionStage.class.getName());
        }
        return false;
    }

    private boolean isMutinyUni(Field field) {
        if (field.hasWrapper()) {
            String wrapperClassName = field.getWrapper().getWrapperClassName();
            return wrapperClassName.equals("io.smallrye.mutiny.Uni");
        }
        return false;
    }

    private boolean isPublisher(Field field) {
        if (field.hasWrapper()) {
            String wrapperClassName = field.getWrapper().getWrapperClassName();
            return wrapperClassName.equals("org.reactivestreams.Publisher");
        }
        return false;
    }

    private boolean isMutinyMulti(Field field) {
        if (field.hasWrapper()) {
            String wrapperClassName = field.getWrapper().getWrapperClassName();
            return wrapperClassName.equals("io.smallrye.mutiny.Multi");
        }
        return false;
    }
}

