/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.datafetcher;

import graphql.execution.DataFetcherResult;
import graphql.schema.DataFetchingEnvironment;
import io.smallrye.graphql.execution.context.SmallRyeContext;
import io.smallrye.graphql.execution.datafetcher.PlugableDataFetcher;
import io.smallrye.graphql.execution.datafetcher.helper.ArgumentHelper;
import io.smallrye.graphql.execution.datafetcher.helper.BatchLoaderHelper;
import io.smallrye.graphql.execution.datafetcher.helper.ContextHelper;
import io.smallrye.graphql.execution.datafetcher.helper.ErrorResultHelper;
import io.smallrye.graphql.execution.datafetcher.helper.FieldHelper;
import io.smallrye.graphql.execution.datafetcher.helper.OperationInvoker;
import io.smallrye.graphql.execution.event.EventEmitter;
import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.transformation.AbstractDataFetcherException;
import org.eclipse.microprofile.graphql.GraphQLException;

public abstract class AbstractDataFetcher<K, T>
implements PlugableDataFetcher<K, T> {
    protected Operation operation;
    protected FieldHelper fieldHelper;
    protected OperationInvoker operationInvoker;
    protected ErrorResultHelper errorResultHelper = new ErrorResultHelper();
    protected ArgumentHelper argumentHelper;
    protected EventEmitter eventEmitter = EventEmitter.getInstance();
    protected BatchLoaderHelper batchLoaderHelper = new BatchLoaderHelper();
    protected ContextHelper contextHelper = new ContextHelper();

    public AbstractDataFetcher(Operation operation) {
        this.operation = operation;
        this.fieldHelper = new FieldHelper((Field)operation);
        this.operationInvoker = new OperationInvoker(operation);
        this.argumentHelper = new ArgumentHelper(operation.getArguments());
    }

    public T get(DataFetchingEnvironment dfe) throws Exception {
        SmallRyeContext context = this.initSmallRyeContext(dfe);
        DataFetcherResult.Builder resultBuilder = DataFetcherResult.newResult().localContext((Object)dfe.getGraphQlContext());
        try {
            Object[] transformedArguments = this.argumentHelper.getArguments(dfe);
            T t = this.invokeAndTransform(dfe, (DataFetcherResult.Builder<Object>)resultBuilder, transformedArguments);
            return t;
        }
        catch (AbstractDataFetcherException abstractDataFetcherException) {
            abstractDataFetcherException.appendDataFetcherResult((DataFetcherResult.Builder<Object>)resultBuilder, dfe);
            this.eventEmitter.fireOnDataFetchError(dfe.getExecutionId().toString(), abstractDataFetcherException);
        }
        catch (GraphQLException graphQLException) {
            this.errorResultHelper.appendPartialResult((DataFetcherResult.Builder<Object>)resultBuilder, dfe, graphQLException);
            this.eventEmitter.fireOnDataFetchError(dfe.getExecutionId().toString(), graphQLException);
        }
        catch (Throwable ex) {
            this.eventEmitter.fireOnDataFetchError(dfe.getExecutionId().toString(), ex);
            throw ex;
        }
        finally {
            this.eventEmitter.fireAfterDataFetch(context);
        }
        return this.invokeFailure((DataFetcherResult.Builder<Object>)resultBuilder);
    }

    private SmallRyeContext initSmallRyeContext(DataFetchingEnvironment dfe) {
        SmallRyeContext context = this.contextHelper.updateSmallRyeContextWithField(dfe, (Field)this.operation);
        this.eventEmitter.fireBeforeDataFetch(context);
        return context;
    }

    protected abstract <T> T invokeAndTransform(DataFetchingEnvironment var1, DataFetcherResult.Builder<Object> var2, Object[] var3) throws AbstractDataFetcherException, Exception;

    protected abstract <T> T invokeFailure(DataFetcherResult.Builder<Object> var1);
}

