/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.datafetcher;

import graphql.execution.DataFetcherResult;
import graphql.schema.DataFetchingEnvironment;
import io.smallrye.graphql.SmallRyeGraphQLServerMessages;
import io.smallrye.graphql.execution.context.SmallRyeContext;
import io.smallrye.graphql.execution.datafetcher.AbstractDataFetcher;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.transformation.AbstractDataFetcherException;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.dataloader.BatchLoaderEnvironment;
import org.eclipse.microprofile.graphql.GraphQLException;

public class UniDataFetcher<K, T>
extends AbstractDataFetcher<K, T> {
    public UniDataFetcher(Operation operation) {
        super(operation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <O> O invokeAndTransform(DataFetchingEnvironment dfe, DataFetcherResult.Builder<Object> resultBuilder, Object[] transformedArguments) throws Exception {
        SmallRyeContext context = this.contextHelper.getSmallRyeContext(dfe);
        try {
            SmallRyeContext.setContext(context);
            Uni uni = (Uni)this.operationInvoker.invoke(transformedArguments);
            CompletableFuture completableFuture = uni.onItemOrFailure().transformToUni((result, throwable, emitter) -> {
                if (throwable != null) {
                    this.eventEmitter.fireOnDataFetchError(dfe.getExecutionId().toString(), (Throwable)throwable);
                    if (throwable instanceof GraphQLException) {
                        GraphQLException graphQLException = (GraphQLException)throwable;
                        this.errorResultHelper.appendPartialResult(resultBuilder, dfe, graphQLException);
                    } else {
                        if (throwable instanceof Exception) {
                            emitter.fail((Throwable)SmallRyeGraphQLServerMessages.msg.dataFetcherException(this.operation, (Throwable)throwable));
                            return;
                        }
                        if (throwable instanceof Error) {
                            emitter.fail(throwable);
                            return;
                        }
                    }
                } else {
                    try {
                        resultBuilder.data(this.fieldHelper.transformOrAdaptResponse(result, dfe));
                    }
                    catch (AbstractDataFetcherException te) {
                        te.appendDataFetcherResult(resultBuilder, dfe);
                    }
                }
                emitter.complete((Object)resultBuilder.build());
            }).runSubscriptionOn(Infrastructure.getDefaultExecutor()).subscribe().asCompletionStage();
            return (O)completableFuture;
        }
        finally {
            SmallRyeContext.remove();
        }
    }

    @Override
    protected <O> O invokeFailure(DataFetcherResult.Builder<Object> resultBuilder) {
        return (O)Uni.createFrom().item(() -> resultBuilder.build()).runSubscriptionOn(Infrastructure.getDefaultExecutor()).subscribe().asCompletionStage();
    }

    public CompletionStage<List<T>> load(List<K> keys, BatchLoaderEnvironment ble) {
        Object[] arguments = this.batchLoaderHelper.getArguments(keys, ble);
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        return ((Uni)this.operationInvoker.invokePrivileged(tccl, arguments)).runSubscriptionOn(Infrastructure.getDefaultExecutor()).subscribe().asCompletionStage();
    }
}

