/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.datafetcher;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import io.smallrye.graphql.execution.context.SmallRyeBatchLoaderContextProvider;
import io.smallrye.graphql.execution.context.SmallRyeContext;
import io.smallrye.graphql.execution.datafetcher.helper.ArgumentHelper;
import io.smallrye.graphql.execution.datafetcher.helper.BatchLoaderHelper;
import io.smallrye.graphql.execution.datafetcher.helper.ContextHelper;
import io.smallrye.graphql.execution.event.EventEmitter;
import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.mutiny.Uni;
import java.util.concurrent.CompletableFuture;
import org.dataloader.DataLoader;

public class BatchDataFetcher<T>
implements DataFetcher<T> {
    private final Operation operation;
    private final ArgumentHelper argumentHelper;
    private final String batchLoaderName;
    private final BatchLoaderHelper batchLoaderHelper = new BatchLoaderHelper();
    private final ContextHelper contextHelper = new ContextHelper();
    private final EventEmitter eventEmitter = EventEmitter.getInstance();

    public BatchDataFetcher(Operation operation) {
        this.operation = operation;
        this.argumentHelper = new ArgumentHelper(operation.getArguments());
        this.batchLoaderName = this.batchLoaderHelper.getName(operation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(DataFetchingEnvironment dfe) throws Exception {
        SmallRyeContext smallryeContext = this.contextHelper.updateSmallRyeContextWithField(dfe, (Field)this.operation);
        this.eventEmitter.fireBeforeDataFetch(smallryeContext);
        Object[] transformedArguments = this.argumentHelper.getArguments(dfe, true);
        Object source = dfe.getSource();
        DataLoader dataLoader = dfe.getDataLoader(this.batchLoaderName);
        SmallRyeBatchLoaderContextProvider.getForDataLoader(dataLoader).set(smallryeContext);
        try {
            SmallRyeContext.setContext(smallryeContext);
            CompletableFuture completableFuture = Uni.createFrom().completionStage(() -> dataLoader.load(source, (Object)transformedArguments)).subscribe().asCompletionStage();
            return (T)completableFuture;
        }
        finally {
            SmallRyeContext.remove();
        }
    }
}

