/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.websocket.graphqltransportws;

import graphql.ExecutionResult;
import io.smallrye.graphql.execution.ExecutionResponse;
import io.smallrye.graphql.execution.ExecutionService;
import io.smallrye.graphql.websocket.GraphQLWebSocketSession;
import io.smallrye.graphql.websocket.GraphQLWebsocketHandler;
import io.smallrye.graphql.websocket.graphqltransportws.MessageType;
import io.smallrye.mutiny.Uni;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import javax.json.stream.JsonParsingException;
import org.jboss.logging.Logger;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class GraphQLTransportWSSubprotocolHandler
implements GraphQLWebsocketHandler {
    private final Logger LOG = Logger.getLogger((String)GraphQLTransportWSSubprotocolHandler.class.getName());
    private final GraphQLWebSocketSession session;
    private final ExecutionService executionService;
    private final AtomicBoolean connectionInitialized;
    private final String CONNECTION_ACK_MESSAGE;
    private final String PONG_MESSAGE;
    private final Map<String, Subscriber<ExecutionResult>> activeOperations;
    private static final Subscriber<ExecutionResult> SINGLE_RESULT_MARKER = new Subscriber<ExecutionResult>(){

        public void onSubscribe(Subscription s) {
        }

        public void onNext(ExecutionResult executionResult) {
        }

        public void onError(Throwable t) {
        }

        public void onComplete() {
        }
    };

    public GraphQLTransportWSSubprotocolHandler(GraphQLWebSocketSession session, ExecutionService executionService) {
        this.session = session;
        this.executionService = executionService;
        this.connectionInitialized = new AtomicBoolean(false);
        this.CONNECTION_ACK_MESSAGE = this.createConnectionAckMessage().toString();
        this.PONG_MESSAGE = this.createPongMessage().toString();
        this.activeOperations = new ConcurrentHashMap<String, Subscriber<ExecutionResult>>();
    }

    @Override
    public void onMessage(String text) {
        Uni.createFrom().item(() -> this.handle(text)).subscribe().asCompletionStage();
    }

    Void handle(String text) {
        if (this.LOG.isTraceEnabled()) {
            this.LOG.trace((Object)("<<< " + text));
        }
        JsonObject message = null;
        MessageType messageType = null;
        try {
            message = this.parseIncomingMessage(text);
            messageType = this.getMessageType(message);
        }
        catch (JsonParsingException ex) {
            this.session.close((short)4400, ex.getMessage());
            return null;
        }
        catch (IllegalArgumentException | NullPointerException ex) {
            this.session.close((short)4400, "Unknown message type");
            return null;
        }
        try {
            switch (messageType) {
                case CONNECTION_INIT: {
                    if (this.connectionInitialized.getAndSet(true)) {
                        this.session.close((short)4429, "Too many initialisation requests");
                        break;
                    }
                    this.session.sendMessage(this.CONNECTION_ACK_MESSAGE);
                    break;
                }
                case PING: {
                    this.session.sendMessage(this.PONG_MESSAGE);
                    break;
                }
                case PONG: {
                    break;
                }
                case SUBSCRIBE: {
                    if (!this.connectionInitialized.get()) {
                        this.session.close((short)4401, "Unauthorized");
                        return null;
                    }
                    String operationId = message.getString("id");
                    if (this.activeOperations.putIfAbsent(operationId, SINGLE_RESULT_MARKER) != null) {
                        this.session.close((short)4409, "Subscriber for " + operationId + " already exists");
                        return null;
                    }
                    JsonObject payload = message.getJsonObject("payload");
                    ExecutionResponse executionResponse = this.executionService.execute(payload);
                    ExecutionResult executionResult = executionResponse.getExecutionResult();
                    if (executionResult == null) break;
                    if (!executionResult.isDataPresent()) {
                        this.session.sendMessage(this.createErrorMessage(operationId, executionResponse.getExecutionResultAsJsonObject().getJsonArray("errors")).toString());
                        break;
                    }
                    Object data = executionResponse.getExecutionResult().getData();
                    if (data instanceof Map) {
                        if (this.activeOperations.remove(operationId) != null) {
                            this.session.sendMessage(this.createNextMessage(operationId, executionResponse.getExecutionResultAsJsonObject()).toString());
                            this.session.sendMessage(this.createCompleteMessage(operationId).toString());
                        }
                        break;
                    }
                    if (data instanceof Publisher) {
                        SubscriptionSubscriber subscriber = new SubscriptionSubscriber(this.session, operationId);
                        Publisher stream = (Publisher)executionResponse.getExecutionResult().getData();
                        if (stream != null) {
                            this.activeOperations.put(operationId, subscriber);
                            stream.subscribe((Subscriber)subscriber);
                        }
                        break;
                    }
                    this.LOG.warn((Object)("Unknown execution result of type " + executionResponse.getExecutionResult().getData().getClass()));
                    break;
                }
                case COMPLETE: {
                    String opId = message.getString("id");
                    Subscriber<ExecutionResult> subscriber = this.activeOperations.remove(opId);
                    if (subscriber != null) {
                        if (subscriber instanceof SubscriptionSubscriber) {
                            ((SubscriptionSubscriber)subscriber).cancel();
                        }
                        if (!this.LOG.isDebugEnabled()) break;
                        this.LOG.debug((Object)("Completed operation id " + opId + " per client's request"));
                        break;
                    }
                    if (!this.LOG.isDebugEnabled()) break;
                    this.LOG.debug((Object)("Client requested to complete operation id " + opId + ", but no such operation is active"));
                    break;
                }
            }
        }
        catch (IOException e) {
            this.LOG.warn((Object)e);
        }
        return null;
    }

    @Override
    public void onThrowable(Throwable t) {
        this.LOG.warn((Object)"Error in websocket", t);
    }

    @Override
    public void onClose() {
        this.LOG.debug((Object)("GraphQL-over-websocket session " + this.session + " closed"));
        if (!this.session.isClosed()) {
            this.session.close((short)1000, "");
        }
    }

    @Override
    public void onEnd() {
    }

    private MessageType getMessageType(JsonObject message) {
        return MessageType.fromString(message.getString("type"));
    }

    private JsonObject parseIncomingMessage(String message) {
        return Json.createReader((Reader)new StringReader(message)).readObject();
    }

    private JsonObject createConnectionAckMessage() {
        return Json.createObjectBuilder().add("type", "connection_ack").build();
    }

    private JsonObject createNextMessage(String operationId, JsonObject payload) {
        return Json.createObjectBuilder().add("type", "next").add("id", operationId).add("payload", (JsonValue)payload).build();
    }

    private JsonObject createCompleteMessage(String operationId) {
        return Json.createObjectBuilder().add("type", "complete").add("id", operationId).build();
    }

    private JsonObject createPongMessage() {
        return Json.createObjectBuilder().add("type", "pong").build();
    }

    private JsonObject createErrorMessage(String operationId, JsonArray errors) {
        return Json.createObjectBuilder().add("id", operationId).add("type", "error").add("payload", (JsonValue)errors).build();
    }

    private class SubscriptionSubscriber
    implements Subscriber<ExecutionResult> {
        private final AtomicReference<Subscription> subscription = new AtomicReference();
        private final GraphQLWebSocketSession session;
        private final String operationId;

        public SubscriptionSubscriber(GraphQLWebSocketSession session, String operationId) {
            this.session = session;
            this.operationId = operationId;
        }

        public void onSubscribe(Subscription s) {
            this.subscription.set(s);
            this.subscription.get().request(1L);
        }

        public void onNext(ExecutionResult executionResult) {
            if (!this.session.isClosed()) {
                ExecutionResponse executionResponse = new ExecutionResponse(executionResult);
                try {
                    this.session.sendMessage(GraphQLTransportWSSubprotocolHandler.this.createNextMessage(this.operationId, executionResponse.getExecutionResultAsJsonObject()).toString());
                }
                catch (IOException e) {
                    GraphQLTransportWSSubprotocolHandler.this.LOG.warn((Object)e);
                }
                this.subscription.get().request(1L);
            }
        }

        public void onError(Throwable t) {
            t.printStackTrace();
        }

        public void onComplete() {
            if (GraphQLTransportWSSubprotocolHandler.this.LOG.isTraceEnabled()) {
                GraphQLTransportWSSubprotocolHandler.this.LOG.trace((Object)("Subscription with id " + this.operationId + " completed"));
            }
            try {
                this.session.sendMessage(GraphQLTransportWSSubprotocolHandler.this.createCompleteMessage(this.operationId).toString());
            }
            catch (IOException e) {
                GraphQLTransportWSSubprotocolHandler.this.LOG.warn((Object)e);
            }
            GraphQLTransportWSSubprotocolHandler.this.activeOperations.remove(this.operationId);
        }

        public void cancel() {
            this.subscription.get().cancel();
        }
    }
}

