/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.websocket.graphqlws;

import graphql.ExecutionResult;
import io.smallrye.graphql.execution.ExecutionResponse;
import io.smallrye.graphql.execution.ExecutionService;
import io.smallrye.graphql.websocket.GraphQLWebSocketSession;
import io.smallrye.graphql.websocket.GraphQLWebsocketHandler;
import io.smallrye.graphql.websocket.graphqlws.MessageType;
import io.smallrye.mutiny.Uni;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonValue;
import javax.json.stream.JsonParsingException;
import org.jboss.logging.Logger;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class GraphQLWSSubprotocolHandler
implements GraphQLWebsocketHandler {
    private final Logger LOG = Logger.getLogger((String)GraphQLWSSubprotocolHandler.class.getName());
    private final GraphQLWebSocketSession session;
    private final ExecutionService executionService;
    private final AtomicBoolean connectionInitialized;
    private final String CONNECTION_ACK_MESSAGE;
    private final Map<String, Subscriber<ExecutionResult>> activeOperations;
    private static final Subscriber<ExecutionResult> SINGLE_RESULT_MARKER = new Subscriber<ExecutionResult>(){

        public void onSubscribe(Subscription s) {
        }

        public void onNext(ExecutionResult executionResult) {
        }

        public void onError(Throwable t) {
        }

        public void onComplete() {
        }
    };

    public GraphQLWSSubprotocolHandler(GraphQLWebSocketSession session, ExecutionService executionService) {
        this.session = session;
        this.executionService = executionService;
        this.connectionInitialized = new AtomicBoolean(false);
        this.CONNECTION_ACK_MESSAGE = this.createConnectionAckMessage().toString();
        this.activeOperations = new ConcurrentHashMap<String, Subscriber<ExecutionResult>>();
    }

    @Override
    public void onMessage(String text) {
        Uni.createFrom().item(() -> this.handle(text)).subscribe().asCompletionStage();
    }

    Void handle(String text) {
        if (this.LOG.isTraceEnabled()) {
            this.LOG.trace((Object)("<<< " + text));
        }
        JsonObject message = null;
        MessageType messageType = null;
        try {
            message = this.parseIncomingMessage(text);
            messageType = this.getMessageType(message);
        }
        catch (JsonParsingException ex) {
            this.session.close((short)4400, ex.getMessage());
            return null;
        }
        catch (IllegalArgumentException | NullPointerException ex) {
            this.session.close((short)4400, "Unknown message type");
            return null;
        }
        try {
            switch (messageType) {
                case GQL_CONNECTION_INIT: {
                    if (this.connectionInitialized.getAndSet(true)) {
                        this.session.close((short)4429, "Too many initialization requests");
                        break;
                    }
                    this.session.sendMessage(this.CONNECTION_ACK_MESSAGE);
                    break;
                }
                case GQL_START: {
                    if (!this.connectionInitialized.get()) {
                        this.session.close((short)4429, "Connection not initialized");
                        return null;
                    }
                    String operationId = message.getString("id");
                    if (this.activeOperations.putIfAbsent(operationId, SINGLE_RESULT_MARKER) != null) {
                        this.session.close((short)4409, "Subscriber for " + operationId + " already exists");
                        return null;
                    }
                    JsonObject payload = message.getJsonObject("payload");
                    ExecutionResponse executionResponse = this.executionService.execute(payload);
                    ExecutionResult executionResult = executionResponse.getExecutionResult();
                    if (executionResult == null) break;
                    if (!executionResult.isDataPresent()) {
                        this.session.sendMessage(this.createErrorMessage(operationId, ((JsonValue)executionResponse.getExecutionResultAsJsonObject().getJsonArray("errors").get(0)).asJsonObject()).toString());
                        break;
                    }
                    Object data = executionResponse.getExecutionResult().getData();
                    if (data instanceof Map) {
                        if (this.activeOperations.remove(operationId) != null) {
                            this.session.sendMessage(this.createDataMessage(operationId, executionResponse.getExecutionResultAsJsonObject()).toString());
                            this.session.sendMessage(this.createCompleteMessage(operationId).toString());
                        }
                        break;
                    }
                    if (data instanceof Publisher) {
                        SubscriptionSubscriber subscriber = new SubscriptionSubscriber(this.session, operationId);
                        Publisher stream = (Publisher)executionResponse.getExecutionResult().getData();
                        if (stream != null) {
                            this.activeOperations.put(operationId, subscriber);
                            stream.subscribe((Subscriber)subscriber);
                        }
                        break;
                    }
                    this.LOG.warn((Object)("Unknown execution result of type " + executionResponse.getExecutionResult().getData().getClass()));
                    break;
                }
                case GQL_STOP: {
                    String opId = message.getString("id");
                    Subscriber<ExecutionResult> subscriber = this.activeOperations.remove(opId);
                    if (subscriber != null) {
                        if (subscriber instanceof SubscriptionSubscriber) {
                            ((SubscriptionSubscriber)subscriber).cancel();
                        }
                        if (!this.LOG.isDebugEnabled()) break;
                        this.LOG.debug((Object)("Completed operation id " + opId + " per client's request"));
                        break;
                    }
                    if (!this.LOG.isDebugEnabled()) break;
                    this.LOG.debug((Object)("Client requested to complete operation id " + opId + ", but no such operation is active"));
                }
            }
        }
        catch (IOException e) {
            this.LOG.warn((Object)e);
        }
        return null;
    }

    @Override
    public void onThrowable(Throwable t) {
        this.LOG.warn((Object)"Error in websocket", t);
    }

    @Override
    public void onClose() {
        this.LOG.debug((Object)("GraphQL-over-websocket session " + this.session + " closed"));
        if (!this.session.isClosed()) {
            this.session.close((short)1000, "");
        }
    }

    @Override
    public void onEnd() {
    }

    private MessageType getMessageType(JsonObject message) {
        return MessageType.fromString(message.getString("type"));
    }

    private JsonObject parseIncomingMessage(String message) {
        return Json.createReader((Reader)new StringReader(message)).readObject();
    }

    private JsonObject createConnectionAckMessage() {
        return Json.createObjectBuilder().add("type", MessageType.GQL_CONNECTION_ACK.asString()).build();
    }

    private JsonObject createDataMessage(String operationId, JsonObject payload) {
        return Json.createObjectBuilder().add("type", MessageType.GQL_DATA.asString()).add("id", operationId).add("payload", (JsonValue)payload).build();
    }

    private JsonObject createCompleteMessage(String operationId) {
        return Json.createObjectBuilder().add("type", MessageType.GQL_COMPLETE.asString()).add("id", operationId).build();
    }

    private JsonObject createErrorMessage(String operationId, JsonObject error) {
        return Json.createObjectBuilder().add("id", operationId).add("type", MessageType.GQL_ERROR.asString()).add("payload", (JsonValue)error).build();
    }

    private class SubscriptionSubscriber
    implements Subscriber<ExecutionResult> {
        private final AtomicReference<Subscription> subscription = new AtomicReference();
        private final GraphQLWebSocketSession session;
        private final String operationId;

        public SubscriptionSubscriber(GraphQLWebSocketSession session, String operationId) {
            this.session = session;
            this.operationId = operationId;
        }

        public void onSubscribe(Subscription s) {
            this.subscription.set(s);
            this.subscription.get().request(1L);
        }

        public void onNext(ExecutionResult executionResult) {
            if (!this.session.isClosed()) {
                ExecutionResponse executionResponse = new ExecutionResponse(executionResult);
                try {
                    this.session.sendMessage(GraphQLWSSubprotocolHandler.this.createDataMessage(this.operationId, executionResponse.getExecutionResultAsJsonObject()).toString());
                }
                catch (IOException e) {
                    GraphQLWSSubprotocolHandler.this.LOG.warn((Object)e);
                }
                this.subscription.get().request(1L);
            }
        }

        public void onError(Throwable t) {
            t.printStackTrace();
        }

        public void onComplete() {
            if (GraphQLWSSubprotocolHandler.this.LOG.isTraceEnabled()) {
                GraphQLWSSubprotocolHandler.this.LOG.trace((Object)("Subscription with id " + this.operationId + " completed"));
            }
            try {
                this.session.sendMessage(GraphQLWSSubprotocolHandler.this.createCompleteMessage(this.operationId).toString());
            }
            catch (IOException e) {
                GraphQLWSSubprotocolHandler.this.LOG.warn((Object)e);
            }
            GraphQLWSSubprotocolHandler.this.activeOperations.remove(this.operationId);
        }

        public void cancel() {
            this.subscription.get().cancel();
        }
    }
}

