package io.smallrye.graphql;

import java.util.Locale;
import java.io.Serializable;
import io.smallrye.graphql.execution.resolver.ConcreteImplementationNotFoundException;
import java.lang.NumberFormatException;
import java.lang.String;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.execution.datafetcher.DataFetcherException;
import java.lang.Exception;
import java.lang.RuntimeException;
import java.time.DateTimeException;
import graphql.schema.CoercingParseValueException;
import java.lang.Throwable;
import java.util.Arrays;
import graphql.schema.CoercingSerializeException;
import java.lang.ClassNotFoundException;
import graphql.schema.CoercingParseLiteralException;
import java.lang.IllegalArgumentException;
import java.lang.UnsupportedOperationException;

/**
 * Warning this class consists of generated code.
 */
public class SmallRyeGraphQLServerMessages_$bundle implements SmallRyeGraphQLServerMessages, Serializable {
    private static final long serialVersionUID = 1L;
    protected SmallRyeGraphQLServerMessages_$bundle() {}
    public static final SmallRyeGraphQLServerMessages_$bundle INSTANCE = new SmallRyeGraphQLServerMessages_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String concreteClassNotFoundForInterface$str() {
        return "No concrete class named [%s] found for interface [%s]";
    }
    @Override
    public final ConcreteImplementationNotFoundException concreteClassNotFoundForInterface(final String clazz, final String iface) {
        final ConcreteImplementationNotFoundException result = new ConcreteImplementationNotFoundException(String.format(getLoggingLocale(), concreteClassNotFoundForInterface$str(), clazz, iface));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String unknownPrimitiveType$str() {
        return "SRGQL000001: Unknown primitive type [%s]";
    }
    @Override
    public final ClassNotFoundException unknownPrimitiveType(final String name) {
        final ClassNotFoundException result = new ClassNotFoundException(String.format(getLoggingLocale(), unknownPrimitiveType$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String dataFetcherException$str() {
        return "SRGQL000002: Data fetching failed for operation [%s]";
    }
    @Override
    public final DataFetcherException dataFetcherException(final Operation operation, final Throwable cause) {
        final DataFetcherException result = new DataFetcherException();
        result.initCause(cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String generalDataFetcherException$str() {
        return "SRGQL000003: Data fetching failed for [%s]";
    }
    @Override
    public final DataFetcherException generalDataFetcherException(final String operation, final Throwable cause) {
        final DataFetcherException result = new DataFetcherException();
        result.initCause(cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String countNotGetInstance$str() {
        return "SRGQL000005: Could not get Instance using the default lookup service";
    }
    @Override
    public final RuntimeException countNotGetInstance(final Throwable t) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), countNotGetInstance$str()), t);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String metricsNotSupportedWithoutCDI$str() {
        return "SRGQL000006: Metrics are not supported without CDI";
    }
    @Override
    public final UnsupportedOperationException metricsNotSupportedWithoutCDI() {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), metricsNotSupportedWithoutCDI$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String openTracingNotSupportedWithoutCDI$str() {
        return "SRGQL000008: OpenTracing is not supported without CDI";
    }
    @Override
    public final UnsupportedOperationException openTracingNotSupportedWithoutCDI() {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), openTracingNotSupportedWithoutCDI$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String canNotLoadClass$str() {
        return "SRGQL000009: Can not load class [%s]";
    }
    @Override
    public final RuntimeException canNotLoadClass(final String className, final Exception cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), canNotLoadClass$str(), className), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String notAValidNumberType$str() {
        return "SRGQL000010: [%s] is not a valid number type";
    }
    @Override
    public final RuntimeException notAValidNumberType(final String typeClassName) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), notAValidNumberType$str(), typeClassName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String numberFormatException$str() {
        return "SRGQL000011: Can not parse a number from [%s]";
    }
    @Override
    public final NumberFormatException numberFormatException(final String input) {
        final NumberFormatException result = new NumberFormatException(String.format(getLoggingLocale(), numberFormatException$str(), input));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String coercingSerializeException$str() {
        return "SRGQL000012: Expected type [%s] but was [%s].";
    }
    @Override
    public final CoercingSerializeException coercingSerializeException(final String expectedType, final String actualType, final Exception cause) {
        final CoercingSerializeException result = new CoercingSerializeException(String.format(getLoggingLocale(), coercingSerializeException$str(), expectedType, actualType), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String coercingParseValueException$str() {
        return "SRGQL000013: Expected type [%s] but was [%s].";
    }
    @Override
    public final CoercingParseValueException coercingParseValueException(final String expectedType, final String actualType, final Exception cause) {
        final CoercingParseValueException result = new CoercingParseValueException(String.format(getLoggingLocale(), coercingParseValueException$str(), expectedType, actualType), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String coercingParseLiteralException2$str() {
        return "SRGQL000014: Expected value to be in the %s range but it was '%s'";
    }
    @Override
    public final CoercingParseLiteralException coercingParseLiteralException(final String expectedRange, final String actual) {
        final CoercingParseLiteralException result = new CoercingParseLiteralException(String.format(getLoggingLocale(), coercingParseLiteralException2$str(), expectedRange, actual));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String coercingParseLiteralException1$str() {
        return "SRGQL000015: Expected AST type 'IntValue' or 'StringValue' but was '%s'.";
    }
    @Override
    public final CoercingParseLiteralException coercingParseLiteralException(final String actualType) {
        final CoercingParseLiteralException result = new CoercingParseLiteralException(String.format(getLoggingLocale(), coercingParseLiteralException1$str(), actualType));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cantParseDate$str() {
        return "SRGQL000016: Can't parse [%s] into [%s]";
    }
    @Override
    public final RuntimeException cantParseDate(final String inputTypeName, final String targetClassName) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), cantParseDate$str(), inputTypeName, targetClassName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String notValidDateOrTimeType$str() {
        return "SRGQL000017: [%s] is no valid date or time-type";
    }
    @Override
    public final RuntimeException notValidDateOrTimeType(final String className) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), notValidDateOrTimeType$str(), className));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownDateFormat$str() {
        return "SRGQL000018: Unknown date format [%s]";
    }
    @Override
    public final DateTimeException unknownDateFormat(final String input) {
        final DateTimeException result = new DateTimeException(String.format(getLoggingLocale(), unknownDateFormat$str(), input));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unsupportedWrappedClass$str() {
        return "SRGQL000019: Unsupported wrapped type. SmallRye only support DataFetchingEnvironment and not %s";
    }
    @Override
    public final IllegalArgumentException unsupportedWrappedClass(final String className) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unsupportedWrappedClass$str(), className));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String canNotInjectClass$str() {
        return "SRGQL000020: Can not inject an instance of class [%s]. Please make sure it is a CDI bean, also possibly the beans.xml file is needed";
    }
    @Override
    public final RuntimeException canNotInjectClass(final String className, final Exception cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), canNotInjectClass$str(), className), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
}
