/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.datafetcher.helper;

import graphql.schema.DataFetchingEnvironment;
import io.smallrye.graphql.api.Entry;
import io.smallrye.graphql.execution.Classes;
import io.smallrye.graphql.execution.datafetcher.CollectionCreator;
import io.smallrye.graphql.execution.datafetcher.helper.DefaultMapAdapter;
import io.smallrye.graphql.execution.datafetcher.helper.ReflectionInvoker;
import io.smallrye.graphql.schema.model.AdaptWith;
import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.ReferenceType;
import io.smallrye.graphql.schema.model.Wrapper;
import io.smallrye.graphql.spi.ClassloadingService;
import io.smallrye.graphql.transformation.AbstractDataFetcherException;
import io.smallrye.graphql.transformation.Transformer;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public abstract class AbstractHelper {
    protected final ClassloadingService classloadingService = ClassloadingService.get();
    protected final DefaultMapAdapter mapAdapter = new DefaultMapAdapter();
    private final Map<String, Transformer> transformerMap = new HashMap<String, Transformer>();
    private final Map<Integer, ReflectionInvoker> invokerMap = new HashMap<Integer, ReflectionInvoker>();

    protected AbstractHelper() {
    }

    protected boolean shouldTransform(Field field) {
        return field.getReference().getType() == ReferenceType.SCALAR && !field.getReference().getClassName().equals(field.getReference().getGraphQLClassName());
    }

    protected boolean shouldAdapt(Field field) {
        return field.getReference().isAdaptingWith() || field.isAdaptingWith() || field.hasWrapper() && field.getWrapper().isMap();
    }

    public Object transformOrAdapt(Object val, Field field, DataFetchingEnvironment dfe) throws AbstractDataFetcherException {
        val = this.recursiveTransform(val, field, dfe);
        if (this.shouldAdapt(field)) {
            val = this.recursiveAdapting(val, field, dfe);
        }
        return val;
    }

    abstract Object afterRecursiveTransform(Object var1, Field var2, DataFetchingEnvironment var3) throws AbstractDataFetcherException;

    abstract Object singleTransform(Object var1, Field var2) throws AbstractDataFetcherException;

    abstract Object singleAdapting(Object var1, Field var2, DataFetchingEnvironment var3) throws AbstractDataFetcherException;

    Object recursiveTransform(Object inputValue, Field field, DataFetchingEnvironment dfe) throws AbstractDataFetcherException {
        if (inputValue == null) {
            return null;
        }
        if (field.hasWrapper() && field.getWrapper().isArray()) {
            return this.recursiveTransformArray(inputValue, field, dfe);
        }
        if (field.hasWrapper() && field.getWrapper().isMap()) {
            return inputValue;
        }
        if (field.hasWrapper() && field.getWrapper().isCollection()) {
            return this.recursiveTransformCollection(inputValue, field, dfe);
        }
        if (field.hasWrapper() && field.getWrapper().isOptional()) {
            return this.recursiveTransformOptional(inputValue, field, dfe);
        }
        inputValue = this.singleTransform(inputValue, field);
        return this.afterRecursiveTransform(inputValue, field, dfe);
    }

    Object recursiveAdapting(Object inputValue, Field field, DataFetchingEnvironment dfe) throws AbstractDataFetcherException {
        if (inputValue == null) {
            return null;
        }
        if (field.hasWrapper() && field.getWrapper().isArray()) {
            return this.recursiveAdaptArray(inputValue, field, dfe);
        }
        if (Classes.isMap(inputValue) && this.shouldAdaptWithToMap(field)) {
            return this.singleAdapting(inputValue, field, dfe);
        }
        if (this.shouldAdaptWithFromMap(field)) {
            return this.singleAdapting(new HashSet((Collection)inputValue), field, dfe);
        }
        if (field.hasWrapper() && field.getWrapper().isCollection()) {
            return this.recursiveAdaptCollection(inputValue, field, dfe);
        }
        if (field.hasWrapper() && field.getWrapper().isOptional()) {
            return this.recursiveAdaptOptional(inputValue, field, dfe);
        }
        inputValue = this.singleAdapting(inputValue, field, dfe);
        return inputValue;
    }

    private Object recursiveTransformArray(Object array, Field field, DataFetchingEnvironment dfe) throws AbstractDataFetcherException {
        if (Classes.isCollection(array)) {
            array = ((Collection)array).toArray();
        }
        Class<?> classInCollection = this.getArrayType(field);
        if (array.getClass().getComponentType().equals(classInCollection)) {
            return array;
        }
        int length = Array.getLength(array);
        Object targetArray = Array.newInstance(classInCollection, length);
        for (int i = 0; i < length; ++i) {
            Field fieldInCollection = this.getFieldInField(field);
            Object element = Array.get(array, i);
            Object targetElement = this.recursiveTransform(element, fieldInCollection, dfe);
            Array.set(targetArray, i, targetElement);
        }
        return targetArray;
    }

    private Object recursiveAdaptArray(Object array, Field field, DataFetchingEnvironment dfe) throws AbstractDataFetcherException {
        if (Classes.isCollection(array)) {
            array = ((Collection)array).toArray();
        }
        Class<?> classInCollection = this.getArrayType(field);
        if (array.getClass().getComponentType().equals(classInCollection)) {
            return array;
        }
        int length = Array.getLength(array);
        Object targetArray = Array.newInstance(classInCollection, length);
        for (int i = 0; i < length; ++i) {
            Field fieldInCollection = this.getFieldInField(field);
            Object element = Array.get(array, i);
            Object targetElement = this.recursiveAdapting(element, fieldInCollection, dfe);
            Array.set(targetArray, i, targetElement);
        }
        return targetArray;
    }

    private Object recursiveTransformCollection(Object argumentValue, Field field, DataFetchingEnvironment dfe) throws AbstractDataFetcherException {
        Collection givenCollection = this.getGivenCollection(argumentValue);
        String collectionClassName = field.getWrapper().getWrapperClassName();
        Collection<?> convertedCollection = CollectionCreator.newCollection(collectionClassName, givenCollection.size());
        Field fieldInCollection = this.getFieldInField(field);
        for (Object objectInGivenCollection : givenCollection) {
            Object objectInCollection = this.recursiveTransform(objectInGivenCollection, fieldInCollection, dfe);
            convertedCollection.add(objectInCollection);
        }
        return convertedCollection;
    }

    private Object recursiveAdaptCollection(Object argumentValue, Field field, DataFetchingEnvironment dfe) throws AbstractDataFetcherException {
        Collection givenCollection = this.getGivenCollection(argumentValue);
        String collectionClassName = field.getWrapper().getWrapperClassName();
        Collection<?> convertedCollection = CollectionCreator.newCollection(collectionClassName, givenCollection.size());
        Field fieldInCollection = this.getFieldInField(field);
        for (Object objectInGivenCollection : givenCollection) {
            Object objectInCollection = this.recursiveAdapting(objectInGivenCollection, fieldInCollection, dfe);
            convertedCollection.add(objectInCollection);
        }
        return convertedCollection;
    }

    private Optional<Object> recursiveTransformOptional(Object argumentValue, Field field, DataFetchingEnvironment dfe) throws AbstractDataFetcherException {
        if (argumentValue == null || !((Optional)argumentValue).isPresent()) {
            return Optional.empty();
        }
        Optional optional = (Optional)argumentValue;
        Object o = optional.get();
        Field f = this.getFieldInField(field);
        return Optional.of(this.recursiveTransform(o, f, dfe));
    }

    private Optional<Object> recursiveAdaptOptional(Object argumentValue, Field field, DataFetchingEnvironment dfe) throws AbstractDataFetcherException {
        if (argumentValue == null || !((Optional)argumentValue).isPresent()) {
            return Optional.empty();
        }
        Optional optional = (Optional)argumentValue;
        Object o = optional.get();
        Field f = this.getFieldInField(field);
        return Optional.of(this.recursiveAdapting(o, f, dfe));
    }

    protected Class<?> getArrayType(Field field) {
        String classNameInCollection = field.getReference().getClassName();
        Class<?> classInCollection = this.classloadingService.loadClass(classNameInCollection);
        return classInCollection;
    }

    protected Transformer getTransformer(Field field) {
        if (this.transformerMap.containsKey(field.getName())) {
            return this.transformerMap.get(field.getName());
        }
        Transformer transformer = Transformer.transformer(field);
        this.transformerMap.put(field.getName(), transformer);
        return transformer;
    }

    protected ReflectionInvoker getReflectionInvokerForInput(AdaptWith adaptWith) {
        ArrayList<String> parameters = new ArrayList<String>();
        if (adaptWith.getToReference().hasWrapper()) {
            parameters.add(adaptWith.getToReference().getWrapper().getWrapperClassName());
        } else {
            parameters.add(adaptWith.getToReference().getClassName());
        }
        return this.getReflectionInvoker(adaptWith.getAdapterClass(), adaptWith.getFromMethod(), parameters);
    }

    protected ReflectionInvoker getReflectionInvokerForOutput(AdaptWith adaptWith) {
        ArrayList<String> parameters = new ArrayList<String>();
        if (adaptWith.getFromReference().hasWrapper()) {
            parameters.add(adaptWith.getFromReference().getWrapper().getWrapperClassName());
        } else {
            parameters.add(adaptWith.getFromReference().getClassName());
        }
        return this.getReflectionInvoker(adaptWith.getAdapterClass(), adaptWith.getToMethod(), parameters);
    }

    private ReflectionInvoker getReflectionInvoker(String className, String methodName, List<String> parameterClasses) {
        Integer key = this.getKey(className, methodName, parameterClasses);
        if (this.invokerMap.containsKey(key)) {
            return this.invokerMap.get(key);
        }
        ReflectionInvoker reflectionInvoker = new ReflectionInvoker(className, methodName, parameterClasses);
        this.invokerMap.put(key, reflectionInvoker);
        return reflectionInvoker;
    }

    private Integer getKey(String className, String methodName, List<String> parameterClasses) {
        return Objects.hash(className, methodName, parameterClasses.toArray());
    }

    private Field getFieldInField(Field owner) {
        Wrapper ownerWrapper;
        Field child = new Field(owner.getMethodName(), owner.getPropertyName(), owner.getName(), owner.getReference());
        child.setNotNull(owner.isNotNull());
        child.setDescription(owner.getDescription());
        child.setTransformation(owner.getTransformation());
        child.setAdaptTo(owner.getAdaptTo());
        child.setAdaptWith(owner.getAdaptWith());
        child.setDefaultValue(owner.getDefaultValue());
        Wrapper wrapper = owner.getWrapper();
        if (owner.hasWrapper() && (ownerWrapper = owner.getWrapper()).getWrapper() != null) {
            Wrapper childWrapper = ownerWrapper.getWrapper();
            child.setWrapper(childWrapper);
        }
        return child;
    }

    private <T> Collection getGivenCollection(Object argumentValue) {
        if (Classes.isCollection(argumentValue)) {
            return (Collection)argumentValue;
        }
        return Arrays.asList((Object[])argumentValue);
    }

    private boolean shouldAdaptWithFromMap(Field field) {
        if (field.isAdaptingWith()) {
            return field.getAdaptWith().getFromReference().getClassName().equals(Map.class.getName()) || field.getAdaptWith().getFromReference().hasWrapper() && field.getAdaptWith().getFromReference().getWrapper().getWrapperClassName().equals(Map.class.getName());
        }
        return field.hasWrapper() && field.getWrapper().isMap();
    }

    private boolean shouldAdaptWithToMap(Field field) {
        if (field.isAdaptingWith()) {
            return field.getAdaptWith().getToReference().hasWrapper() && field.getAdaptWith().getToReference().getWrapper().getWrapperClassName().equals(Set.class.getName()) && field.getAdaptWith().getToReference().getClassName().equals(Entry.class.getName());
        }
        return field.hasWrapper() && field.getWrapper().isMap();
    }
}

