/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.bootstrap;

import graphql.schema.DataFetcher;
import io.smallrye.graphql.execution.datafetcher.CompletionStageDataFetcher;
import io.smallrye.graphql.execution.datafetcher.DefaultDataFetcher;
import io.smallrye.graphql.execution.datafetcher.FieldDataFetcher;
import io.smallrye.graphql.execution.datafetcher.MultiDataFetcher;
import io.smallrye.graphql.execution.datafetcher.PlugableBatchableDataFetcher;
import io.smallrye.graphql.execution.datafetcher.PlugableDataFetcher;
import io.smallrye.graphql.execution.datafetcher.PublisherDataFetcher;
import io.smallrye.graphql.execution.datafetcher.UniDataFetcher;
import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.schema.model.Reference;
import io.smallrye.graphql.schema.model.Type;
import io.smallrye.graphql.schema.model.Wrapper;
import io.smallrye.graphql.spi.DataFetcherService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.dataloader.BatchLoaderWithContext;

public class DataFetcherFactory {
    private List<DataFetcherService> dataFetcherServices = new ArrayList<DataFetcherService>();

    public DataFetcherFactory() {
        Iterator<DataFetcherService> i = ServiceLoader.load(DataFetcherService.class).iterator();
        while (i.hasNext()) {
            this.dataFetcherServices.add(i.next());
        }
        Collections.sort(this.dataFetcherServices, new Comparator<DataFetcherService>(){

            @Override
            public int compare(DataFetcherService o1, DataFetcherService o2) {
                return o1.getPriority().compareTo(o2.getPriority());
            }
        });
    }

    public <T> DataFetcher<T> getDataFetcher(Operation operation, Type type) {
        return (DataFetcher)this.get(operation, type);
    }

    public <T> PlugableDataFetcher<T> getFieldDataFetcher(Field field, Type type, Reference owner) {
        for (DataFetcherService dfe : this.dataFetcherServices) {
            PlugableDataFetcher df = dfe.getFieldDataFetcher(field, type, owner);
            if (df == null) continue;
            return df;
        }
        return new FieldDataFetcher(field, type, owner);
    }

    public <K, T> BatchLoaderWithContext<K, T> getSourceBatchLoader(Operation operation, Type type) {
        return (BatchLoaderWithContext)this.get(operation, type);
    }

    public Wrapper unwrap(Field field, boolean isBatch) {
        if (this.isFutureLike(field) && isBatch) {
            return field.getWrapper().getWrapper().getWrapper();
        }
        if (this.isFutureLike(field)) {
            return field.getWrapper().getWrapper();
        }
        if (isBatch) {
            return field.getWrapper().getWrapper();
        }
        if (field.hasWrapper() && field.getWrapper().isCollectionOrArrayOrMap()) {
            return field.getWrapper();
        }
        if (field.hasWrapper()) {
            // empty if block
        }
        return null;
    }

    private <V> V get(Operation operation, Type type) {
        if (this.isCompletionStage((Field)operation)) {
            return (V)this.getCompletionStageDataFetcher(operation, type);
        }
        if (this.isMutinyUni((Field)operation)) {
            return (V)this.getUniDataFetcher(operation, type);
        }
        if (this.isPublisher((Field)operation)) {
            return (V)this.getPublisherDataFetcher(operation, type);
        }
        if (this.isMutinyMulti((Field)operation)) {
            return (V)this.getMultiDataFetcher(operation, type);
        }
        if (this.isWrapped((Field)operation)) {
            return (V)this.getOtherWrappedDataFetcher(operation, type);
        }
        return (V)this.getOtherFieldDataFetcher(operation, type);
    }

    private PlugableBatchableDataFetcher getCompletionStageDataFetcher(Operation operation, Type type) {
        for (DataFetcherService dfe : this.dataFetcherServices) {
            PlugableBatchableDataFetcher df = dfe.getCompletionStageDataFetcher(operation, type);
            if (df == null) continue;
            return df;
        }
        return new CompletionStageDataFetcher(operation, type);
    }

    private PlugableBatchableDataFetcher getUniDataFetcher(Operation operation, Type type) {
        for (DataFetcherService dfe : this.dataFetcherServices) {
            PlugableBatchableDataFetcher df = dfe.getUniDataFetcher(operation, type);
            if (df == null) continue;
            return df;
        }
        return new UniDataFetcher(operation, type);
    }

    private PlugableBatchableDataFetcher getPublisherDataFetcher(Operation operation, Type type) {
        for (DataFetcherService dfe : this.dataFetcherServices) {
            PlugableBatchableDataFetcher df = dfe.getPublisherDataFetcher(operation, type);
            if (df == null) continue;
            return df;
        }
        return new PublisherDataFetcher(operation, type);
    }

    private PlugableBatchableDataFetcher getMultiDataFetcher(Operation operation, Type type) {
        for (DataFetcherService dfe : this.dataFetcherServices) {
            PlugableBatchableDataFetcher df = dfe.getMultiDataFetcher(operation, type);
            if (df == null) continue;
            return df;
        }
        return new MultiDataFetcher(operation, type);
    }

    private PlugableBatchableDataFetcher getOtherWrappedDataFetcher(Operation operation, Type type) {
        for (DataFetcherService dfe : this.dataFetcherServices) {
            PlugableBatchableDataFetcher df = dfe.getOtherWrappedDataFetcher(operation, type);
            if (df == null) continue;
            return df;
        }
        return this.getDefaultDataFetcher(operation, type);
    }

    private PlugableBatchableDataFetcher getOtherFieldDataFetcher(Operation operation, Type type) {
        PlugableBatchableDataFetcher df;
        for (DataFetcherService dfe : this.dataFetcherServices) {
            df = dfe.getOtherFieldDataFetcher(operation, type);
            if (df == null) continue;
            return df;
        }
        for (DataFetcherService dfe : this.dataFetcherServices) {
            df = dfe.getDefaultDataFetcher(operation, type);
            if (df == null) continue;
            return df;
        }
        return new DefaultDataFetcher(operation, type);
    }

    private PlugableBatchableDataFetcher getDefaultDataFetcher(Operation operation, Type type) {
        return this.getOtherFieldDataFetcher(operation, type);
    }

    private boolean isFutureLike(Field field) {
        return this.isCompletionStage(field) || this.isMutinyUni(field) || this.isMutinyMulti(field);
    }

    private boolean isWrapped(Field field) {
        return field.hasWrapper();
    }

    private boolean isCompletionStage(Field field) {
        if (field.hasWrapper()) {
            String wrapperClassName = field.getWrapper().getWrapperClassName();
            return wrapperClassName.equals(CompletableFuture.class.getName()) || wrapperClassName.equals(CompletionStage.class.getName());
        }
        return false;
    }

    private boolean isMutinyUni(Field field) {
        if (field.hasWrapper()) {
            String wrapperClassName = field.getWrapper().getWrapperClassName();
            return wrapperClassName.equals("io.smallrye.mutiny.Uni");
        }
        return false;
    }

    private boolean isPublisher(Field field) {
        if (field.hasWrapper()) {
            String wrapperClassName = field.getWrapper().getWrapperClassName();
            return wrapperClassName.equals("org.reactivestreams.Publisher");
        }
        return false;
    }

    private boolean isMutinyMulti(Field field) {
        if (field.hasWrapper()) {
            String wrapperClassName = field.getWrapper().getWrapperClassName();
            return wrapperClassName.equals("io.smallrye.mutiny.Multi");
        }
        return false;
    }
}

