/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.datafetcher;

import graphql.execution.DataFetcherResult;
import graphql.schema.DataFetchingEnvironment;
import io.smallrye.graphql.api.Context;
import io.smallrye.graphql.execution.context.SmallRyeContext;
import io.smallrye.graphql.execution.context.SmallRyeContextManager;
import io.smallrye.graphql.execution.datafetcher.PlugableBatchableDataFetcher;
import io.smallrye.graphql.execution.datafetcher.helper.ArgumentHelper;
import io.smallrye.graphql.execution.datafetcher.helper.BatchLoaderHelper;
import io.smallrye.graphql.execution.datafetcher.helper.ErrorResultHelper;
import io.smallrye.graphql.execution.datafetcher.helper.FieldHelper;
import io.smallrye.graphql.execution.datafetcher.helper.OperationInvoker;
import io.smallrye.graphql.execution.event.EventEmitter;
import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.schema.model.Type;
import io.smallrye.graphql.transformation.AbstractDataFetcherException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.dataloader.BatchLoaderEnvironment;
import org.eclipse.microprofile.graphql.GraphQLException;

public abstract class AbstractDataFetcher<K, T>
implements PlugableBatchableDataFetcher<K, T> {
    protected Operation operation;
    protected Type type;
    protected FieldHelper fieldHelper;
    protected OperationInvoker operationInvoker;
    protected ErrorResultHelper errorResultHelper = new ErrorResultHelper();
    protected ArgumentHelper argumentHelper;
    protected EventEmitter eventEmitter = EventEmitter.getInstance();
    protected BatchLoaderHelper batchLoaderHelper = new BatchLoaderHelper();

    public AbstractDataFetcher(Operation operation, Type type) {
        this.operation = operation;
        this.type = type;
        this.fieldHelper = new FieldHelper((Field)operation);
        this.operationInvoker = new OperationInvoker(operation);
        this.argumentHelper = new ArgumentHelper(operation.getArguments());
    }

    public T get(DataFetchingEnvironment dfe) throws Exception {
        SmallRyeContext smallRyeContext = SmallRyeContextManager.populateFromDataFetchingEnvironment(this.type, (Field)this.operation, dfe);
        this.eventEmitter.fireBeforeDataFetch(smallRyeContext);
        DataFetcherResult.Builder resultBuilder = DataFetcherResult.newResult().localContext((Object)dfe.getGraphQlContext());
        try {
            List<Object> transformedArguments = this.argumentHelper.getArguments(dfe);
            T t = this.invokeAndTransform(smallRyeContext, dfe, (DataFetcherResult.Builder<Object>)resultBuilder, transformedArguments.toArray());
            return t;
        }
        catch (AbstractDataFetcherException abstractDataFetcherException) {
            abstractDataFetcherException.appendDataFetcherResult((DataFetcherResult.Builder<Object>)resultBuilder, dfe);
            this.eventEmitter.fireOnDataFetchError(smallRyeContext, abstractDataFetcherException);
        }
        catch (GraphQLException graphQLException) {
            this.errorResultHelper.appendPartialResult((DataFetcherResult.Builder<Object>)resultBuilder, dfe, graphQLException);
            this.eventEmitter.fireOnDataFetchError(smallRyeContext, graphQLException);
        }
        catch (Throwable ex) {
            this.eventEmitter.fireOnDataFetchError(smallRyeContext, ex);
            throw ex;
        }
        finally {
            this.eventEmitter.fireAfterDataFetch(smallRyeContext);
        }
        return this.invokeFailure((DataFetcherResult.Builder<Object>)resultBuilder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletionStage<List<T>> load(List<K> keys, BatchLoaderEnvironment ble) {
        Map<String, Object> batchContext = this.batchLoaderHelper.getBatchContext(keys, ble);
        Object[] arguments = this.batchLoaderHelper.getArguments(batchContext);
        DataFetchingEnvironment dataFetchingEnvironment = this.batchLoaderHelper.getDataFetchingEnvironment(batchContext);
        try {
            SmallRyeContext smallRyeContext = SmallRyeContextManager.populateFromDataFetchingEnvironment(this.type, (Field)this.operation, dataFetchingEnvironment);
            CompletionStage<List<T>> completionStage = this.invokeBatch(dataFetchingEnvironment, arguments);
            return completionStage;
        }
        finally {
            SmallRyeContextManager.clearCurrentSmallRyeContext();
        }
    }

    protected abstract <T> T invokeAndTransform(Context var1, DataFetchingEnvironment var2, DataFetcherResult.Builder<Object> var3, Object[] var4) throws AbstractDataFetcherException, Exception;

    protected abstract <T> T invokeFailure(DataFetcherResult.Builder<Object> var1);

    protected abstract CompletionStage<List<T>> invokeBatch(DataFetchingEnvironment var1, Object[] var2);
}

