/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.error;

import graphql.ExceptionWhileDataFetching;
import graphql.GraphQLError;
import graphql.validation.ValidationError;
import io.smallrye.graphql.execution.error.ErrorExtensionProviders;
import io.smallrye.graphql.spi.config.Config;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import javax.json.JsonValue;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.JsonbConfig;

public class ExecutionErrorsService {
    private static final JsonBuilderFactory jsonBuilderFactory = Json.createBuilderFactory(null);
    private static final JsonReaderFactory jsonReaderFactory = Json.createReaderFactory(null);
    private static final Jsonb JSONB = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withNullValues(Boolean.TRUE).withFormatting(Boolean.TRUE));
    private final ErrorExtensionProviders errorExtensionProviders = new ErrorExtensionProviders();
    private final Config config = Config.get();
    private static final String EXTENSIONS = "extensions";

    public JsonArray toJsonErrors(List<GraphQLError> errors) {
        JsonArrayBuilder arrayBuilder = jsonBuilderFactory.createArrayBuilder();
        for (GraphQLError e : errors) {
            arrayBuilder.add((JsonValue)this.toJsonError(e));
        }
        return arrayBuilder.build();
    }

    private JsonObject toJsonError(GraphQLError error) {
        String json = JSONB.toJson((Object)error.toSpecification());
        try (StringReader sr = new StringReader(json);){
            JsonObject jsonObject2;
            block11: {
                JsonReader reader = jsonReaderFactory.createReader((Reader)sr);
                try {
                    JsonObject jsonErrors = reader.readObject();
                    JsonObjectBuilder resultBuilder = jsonBuilderFactory.createObjectBuilder(jsonErrors);
                    this.getOptionalExtensions(error).ifPresent(jsonObject -> resultBuilder.add(EXTENSIONS, (JsonValue)jsonObject));
                    jsonObject2 = resultBuilder.build();
                    if (reader == null) break block11;
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                reader.close();
            }
            return jsonObject2;
        }
    }

    private Optional<JsonObject> getOptionalExtensions(GraphQLError error) {
        if (error instanceof ValidationError) {
            return this.getValidationExtensions((ValidationError)error);
        }
        if (error instanceof ExceptionWhileDataFetching) {
            return this.getDataFetchingExtensions((ExceptionWhileDataFetching)error);
        }
        return Optional.empty();
    }

    private Optional<JsonObject> getValidationExtensions(ValidationError error) {
        if (this.config.getErrorExtensionFields().isPresent()) {
            JsonObjectBuilder objectBuilder = jsonBuilderFactory.createObjectBuilder();
            this.addKeyValue(objectBuilder, "description", error.getDescription());
            this.addKeyValue(objectBuilder, "validationErrorType", error.getValidationErrorType().toString());
            objectBuilder.add("queryPath", (JsonValue)this.toJsonArray(error.getQueryPath()));
            this.addKeyValue(objectBuilder, "classification", error.getErrorType().toString());
            Map extensions = error.getExtensions();
            this.populateCustomExtensions(objectBuilder, extensions);
            return Optional.of(objectBuilder.build());
        }
        return Optional.empty();
    }

    private Optional<JsonObject> getDataFetchingExtensions(ExceptionWhileDataFetching error) {
        if (this.config.getErrorExtensionFields().isPresent()) {
            Throwable exception = error.getException();
            JsonObjectBuilder objectBuilder = jsonBuilderFactory.createObjectBuilder();
            this.addKeyValue(objectBuilder, "classification", error.getErrorType().toString());
            this.addErrorExtensions(objectBuilder, exception);
            Map extensions = error.getExtensions();
            this.populateCustomExtensions(objectBuilder, extensions);
            return Optional.of(objectBuilder.build());
        }
        return Optional.empty();
    }

    private void addErrorExtensions(JsonObjectBuilder objectBuilder, Throwable exception) {
        this.errorExtensionProviders.get().forEach(provider -> this.addKeyValue(objectBuilder, provider.getKey(), provider.mapValueFrom(exception)));
    }

    private void populateCustomExtensions(JsonObjectBuilder objectBuilder, Map<String, Object> extensions) {
        if (extensions != null) {
            for (Map.Entry<String, Object> entry : extensions.entrySet()) {
                if (!this.config.getErrorExtensionFields().isEmpty() && (!this.config.getErrorExtensionFields().isPresent() || !this.config.getErrorExtensionFields().get().contains(entry.getKey()))) continue;
                this.addKeyValue(objectBuilder, entry.getKey(), entry.getValue().toString());
            }
        }
    }

    private JsonArray toJsonArray(List<?> list) {
        JsonArrayBuilder arrayBuilder = jsonBuilderFactory.createArrayBuilder();
        if (list != null && !list.isEmpty()) {
            for (Object o : list) {
                if (o == null) continue;
                arrayBuilder.add(o.toString());
            }
        }
        return arrayBuilder.build();
    }

    private void addKeyValue(JsonObjectBuilder objectBuilder, String key, String value) {
        this.addKeyValue(objectBuilder, key, (JsonValue)Json.createValue((String)value));
    }

    private void addKeyValue(JsonObjectBuilder objectBuilder, String key, JsonValue value) {
        if (this.config.getErrorExtensionFields().isPresent()) {
            List<String> fieldsThatShouldBeIncluded = this.config.getErrorExtensionFields().get();
            if (fieldsThatShouldBeIncluded.contains(key)) {
                objectBuilder.add(key, value);
            }
        } else if (value != null) {
            objectBuilder.add(key, value);
        }
    }
}

