/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.datafetcher;

import graphql.execution.DataFetcherResult;
import graphql.schema.DataFetchingEnvironment;
import io.smallrye.graphql.SmallRyeGraphQLServerMessages;
import io.smallrye.graphql.execution.datafetcher.AbstractDataFetcher;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.schema.model.Type;
import io.smallrye.graphql.transformation.AbstractDataFetcherException;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.eclipse.microprofile.graphql.GraphQLException;

public abstract class AbstractAsyncDataFetcher<K, T>
extends AbstractDataFetcher<K, T> {
    public AbstractAsyncDataFetcher(Operation operation, Type type) {
        super(operation, type);
    }

    @Override
    protected <O> O invokeAndTransform(DataFetchingEnvironment dfe, DataFetcherResult.Builder<Object> resultBuilder, Object[] transformedArguments) throws Exception {
        Uni<?> uni = this.handleUserMethodCall(dfe, transformedArguments);
        return (O)uni.onItemOrFailure().transformToUni((result, throwable, emitter) -> {
            if (throwable != null) {
                this.eventEmitter.fireOnDataFetchError(dfe.getExecutionId().toString(), (Throwable)throwable);
                if (throwable instanceof GraphQLException) {
                    GraphQLException graphQLException = (GraphQLException)throwable;
                    this.errorResultHelper.appendPartialResult(resultBuilder, dfe, graphQLException);
                } else {
                    if (throwable instanceof Exception) {
                        emitter.fail((Throwable)SmallRyeGraphQLServerMessages.msg.dataFetcherException(this.operation, (Throwable)throwable));
                        return;
                    }
                    if (throwable instanceof Error) {
                        emitter.fail(throwable);
                        return;
                    }
                }
            } else {
                try {
                    resultBuilder.data(this.fieldHelper.transformOrAdaptResponse(result, dfe));
                }
                catch (AbstractDataFetcherException te) {
                    te.appendDataFetcherResult(resultBuilder, dfe);
                }
            }
            emitter.complete((Object)resultBuilder.build());
        }).runSubscriptionOn(Infrastructure.getDefaultExecutor()).subscribe().asCompletionStage();
    }

    protected abstract Uni<?> handleUserMethodCall(DataFetchingEnvironment var1, Object[] var2) throws Exception;

    @Override
    protected <O> O invokeFailure(DataFetcherResult.Builder<Object> resultBuilder) {
        return (O)Uni.createFrom().item(() -> resultBuilder.build()).runSubscriptionOn(Infrastructure.getDefaultExecutor()).subscribe().asCompletionStage();
    }

    @Override
    protected CompletionStage<List<T>> invokeBatch(DataFetchingEnvironment dfe, Object[] arguments) {
        try {
            return this.handleUserBatchLoad(dfe, arguments).runSubscriptionOn(Infrastructure.getDefaultExecutor()).subscribe().asCompletionStage();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected abstract Uni<List<T>> handleUserBatchLoad(DataFetchingEnvironment var1, Object[] var2) throws Exception;
}

