/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.spi;

import io.smallrye.graphql.SmallRyeGraphQLServerLogging;
import io.smallrye.graphql.SmallRyeGraphQLServerMessages;
import io.smallrye.graphql.spi.ManagedInstance;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;

public interface LookupService {
    public static final ServiceLoader<LookupService> lookupServices = ServiceLoader.load(LookupService.class);
    public static final LookupService lookupService = LookupService.load();

    public static LookupService get() {
        return lookupService;
    }

    public static LookupService load() {
        LookupService ls;
        try {
            ls = lookupServices.iterator().next();
        }
        catch (Exception ex) {
            ls = new DefaultLookupService();
        }
        SmallRyeGraphQLServerLogging.log.usingLookupService(ls.getName());
        return ls;
    }

    public String getName();

    default public Class<?> getClass(Class<?> declaringClass) {
        return declaringClass;
    }

    public <T> ManagedInstance<T> getInstance(Class<T> var1);

    default public boolean isResolvable(Class<?> declaringClass) {
        return true;
    }

    public static class DefaultManagedInstance<T>
    implements ManagedInstance<T> {
        private final T instance;

        public DefaultManagedInstance(T instance) {
            this.instance = instance;
        }

        @Override
        public T get() {
            return this.instance;
        }
    }

    public static class DefaultLookupService
    implements LookupService {
        private final Map<Class, InheritableThreadLocal<ManagedInstance>> instanceMap = new HashMap<Class, InheritableThreadLocal<ManagedInstance>>();

        @Override
        public String getName() {
            return "Thread Local and reflection";
        }

        @Override
        public <T> ManagedInstance<T> getInstance(Class<T> declaringClass) {
            if (this.instanceMap.containsKey(declaringClass)) {
                return (ManagedInstance)this.instanceMap.get(declaringClass).get();
            }
            ManagedInstance<T> newManagedInstance = this.getNewManagedInstance(declaringClass);
            InheritableThreadLocal<ManagedInstance<T>> threadLocal = new InheritableThreadLocal<ManagedInstance<T>>();
            threadLocal.set(newManagedInstance);
            this.instanceMap.put(declaringClass, threadLocal);
            return this.getInstance(declaringClass);
        }

        private <T> ManagedInstance<T> getNewManagedInstance(Class<T> declaringClass) {
            try {
                return new DefaultManagedInstance<T>(declaringClass.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                throw SmallRyeGraphQLServerMessages.msg.countNotGetInstance(ex);
            }
        }
    }
}

