/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.websocket.graphqltransportws;

import io.smallrye.graphql.execution.ExecutionResponse;
import io.smallrye.graphql.execution.ExecutionService;
import io.smallrye.graphql.websocket.AbstractGraphQLWebsocketHandler;
import io.smallrye.graphql.websocket.GraphQLWebSocketSession;
import io.smallrye.graphql.websocket.graphqltransportws.MessageType;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;

public class GraphQLTransportWSSubprotocolHandler
extends AbstractGraphQLWebsocketHandler {
    private final String pingMessage;
    private final String pongMessage = this.createPongMessage().toString();

    public GraphQLTransportWSSubprotocolHandler(GraphQLWebSocketSession session, Map<String, Object> context) {
        super(session, "next", context);
        this.pingMessage = this.createPingMessage().toString();
    }

    @Deprecated
    public GraphQLTransportWSSubprotocolHandler(GraphQLWebSocketSession session, ExecutionService executionService) {
        this(session, Collections.emptyMap());
    }

    @Override
    protected void onMessage(JsonObject message) {
        if (message != null) {
            MessageType messageType = this.getMessageType(message);
            try {
                switch (messageType) {
                    case CONNECTION_INIT: {
                        this.sendConnectionAckMessage();
                        break;
                    }
                    case PING: {
                        this.sendPongMessage();
                        break;
                    }
                    case PONG: {
                        break;
                    }
                    case SUBSCRIBE: {
                        this.sendDataMessage(message);
                        break;
                    }
                    case COMPLETE: {
                        this.sendCancelMessage(message);
                        break;
                    }
                }
            }
            catch (IOException e) {
                this.LOG.warn((Object)e);
            }
        }
    }

    private MessageType getMessageType(JsonObject message) {
        return MessageType.fromString(message.getString("type"));
    }

    @Override
    protected void closeDueToConnectionNotInitialized() {
        this.session.close((short)4401, "Unauthorized");
    }

    @Override
    protected void sendErrorMessage(String operationId, ExecutionResponse executionResponse) throws IOException {
        this.session.sendMessage(this.createErrorMessage(operationId, executionResponse.getExecutionResultAsJsonObject().getJsonArray("errors")).toString());
    }

    private JsonObject createErrorMessage(String operationId, JsonArray errors) {
        return Json.createObjectBuilder().add("id", operationId).add("type", "error").add("payload", (JsonValue)errors).build();
    }

    private void sendPongMessage() throws IOException {
        this.session.sendMessage(this.pongMessage);
    }

    @Override
    protected String getPingMessage() {
        return this.pingMessage;
    }

    private JsonObject createPongMessage() {
        return Json.createObjectBuilder().add("type", "pong").build();
    }

    private JsonObject createPingMessage() {
        return Json.createObjectBuilder().add("type", "ping").build();
    }
}

