/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.spi.config;

import io.smallrye.graphql.execution.datafetcher.DataFetcherException;
import io.smallrye.graphql.spi.config.LogPayloadOption;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.CompletionException;
import org.jboss.logging.Logger;

public interface Config {
    public static final Logger LOG = Logger.getLogger(Config.class);
    public static final ServiceLoader<Config> configs = ServiceLoader.load(Config.class);
    public static final Config config = Config.init();
    public static final String SERVER_ERROR_DEFAULT_MESSAGE = "System error";
    public static final String FIELD_VISIBILITY_DEFAULT = "default";
    public static final String FIELD_VISIBILITY_NO_INTROSPECTION = "no-introspection";
    public static final String ERROR_EXTENSION_EXCEPTION = "exception";
    public static final String ERROR_EXTENSION_CLASSIFICATION = "classification";
    public static final String ERROR_EXTENSION_CODE = "code";
    public static final String ERROR_EXTENSION_DESCRIPTION = "description";
    public static final String ERROR_EXTENSION_VALIDATION_ERROR_TYPE = "validationErrorType";
    public static final String ERROR_EXTENSION_QUERY_PATH = "queryPath";
    public static final List<String> ERROR_EXTENSION_ALL_KNOWN = Arrays.asList("exception", "classification", "code", "description", "validationErrorType", "queryPath");
    public static final List<String> DEFAULT_UNWRAP_EXCEPTIONS = Arrays.asList(CompletionException.class.getName(), DataFetcherException.class.getName(), "javax.ejb.EJBException", "jakarta.ejb.EJBException");

    public static Config init() {
        Config c;
        try {
            c = configs.iterator().next();
        }
        catch (Exception ex) {
            c = new Config(){

                @Override
                public String getName() {
                    return "Default";
                }
            };
        }
        LOG.debug((Object)("Using [" + c.getName() + "] config services"));
        return c;
    }

    public static Config get() {
        return config;
    }

    public String getName();

    default public String getDefaultErrorMessage() {
        return SERVER_ERROR_DEFAULT_MESSAGE;
    }

    default public boolean isPrintDataFetcherException() {
        return false;
    }

    default public Optional<List<String>> getHideErrorMessageList() {
        return Optional.empty();
    }

    default public Optional<List<String>> getShowErrorMessageList() {
        return Optional.empty();
    }

    default public boolean shouldHide(Throwable throwable) {
        List hideList = this.getHideErrorMessageList().orElse(null);
        return this.isListed(throwable, (List<String>)hideList);
    }

    default public boolean shouldShow(Throwable throwable) {
        List showList = this.getShowErrorMessageList().orElse(null);
        return this.isListed(throwable, (List<String>)showList);
    }

    default public boolean isListed(Throwable throwable, List<String> classNames) {
        if (classNames == null || classNames.isEmpty() || throwable == null) {
            return false;
        }
        return this.isListed(throwable.getClass(), classNames);
    }

    default public boolean isListed(Class throwableClass, List<String> classNames) {
        if (classNames == null || classNames.isEmpty() || throwableClass == null || throwableClass.getName().equals(Object.class.getName())) {
            return false;
        }
        for (String configuredValue : classNames) {
            if (configuredValue.equals(throwableClass.getName())) {
                return true;
            }
            if (!configuredValue.endsWith("*")) continue;
            String values = configuredValue.substring(0, configuredValue.length() - 2);
            if (!throwableClass.getName().startsWith(values)) continue;
            return true;
        }
        return this.isListed(throwableClass.getSuperclass(), classNames);
    }

    default public Optional<List<String>> getUnwrapExceptions() {
        return Optional.empty();
    }

    default public boolean shouldUnwrapThrowable(Throwable t) {
        if (this.getUnwrapExceptions().isPresent() && this.getUnwrapExceptions().get().contains(t.getClass().getName()) && t.getCause() != null) {
            return true;
        }
        return DEFAULT_UNWRAP_EXCEPTIONS.contains(t.getClass().getName()) && t.getCause() != null;
    }

    default public boolean isAllowGet() {
        return false;
    }

    default public boolean isAllowPostWithQueryParameters() {
        return false;
    }

    default public boolean isIncludeScalarsInSchema() {
        return false;
    }

    default public boolean isIncludeDirectivesInSchema() {
        return false;
    }

    default public boolean isIncludeSchemaDefinitionInSchema() {
        return false;
    }

    default public boolean isIncludeIntrospectionTypesInSchema() {
        return false;
    }

    default public boolean isTracingEnabled() {
        return false;
    }

    default public boolean isMetricsEnabled() {
        return false;
    }

    default public boolean isValidationEnabled() {
        return false;
    }

    default public boolean isEventsEnabled() {
        return false;
    }

    default public boolean shouldEmitEvents() {
        return this.isTracingEnabled() || this.isMetricsEnabled() || this.isValidationEnabled() || this.isEventsEnabled();
    }

    default public LogPayloadOption logPayload() {
        return LogPayloadOption.off;
    }

    default public Optional<Boolean> isParserCaptureIgnoredChars() {
        return Optional.empty();
    }

    default public Optional<Boolean> isParserCaptureLineComments() {
        return Optional.empty();
    }

    default public Optional<Boolean> isParserCaptureSourceLocation() {
        return Optional.empty();
    }

    default public Optional<Integer> getParserMaxTokens() {
        return Optional.empty();
    }

    default public Optional<Integer> getParserMaxWhitespaceTokens() {
        return Optional.empty();
    }

    default public boolean hasParserOptions() {
        return this.isParserCaptureIgnoredChars().isPresent() || this.isParserCaptureLineComments().isPresent() || this.isParserCaptureSourceLocation().isPresent() || this.getParserMaxTokens().isPresent() || this.getParserMaxWhitespaceTokens().isPresent();
    }

    default public Optional<Integer> getQueryComplexityInstrumentation() {
        return Optional.empty();
    }

    default public Optional<Integer> getQueryDepthInstrumentation() {
        return Optional.empty();
    }

    default public String getFieldVisibility() {
        return FIELD_VISIBILITY_DEFAULT;
    }

    default public Optional<List<String>> getErrorExtensionFields() {
        return Optional.empty();
    }

    default public <T> T getConfigValue(String key, Class<T> type, T defaultValue) {
        return defaultValue;
    }
}

