/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.websocket.graphqlws;

import io.smallrye.graphql.execution.ExecutionResponse;
import io.smallrye.graphql.execution.ExecutionService;
import io.smallrye.graphql.websocket.AbstractGraphQLWebsocketHandler;
import io.smallrye.graphql.websocket.GraphQLWebSocketSession;
import io.smallrye.graphql.websocket.graphqlws.MessageType;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;

public class GraphQLWSSubprotocolHandler
extends AbstractGraphQLWebsocketHandler {
    private final String pingMessage = this.createPingMessage().toString();

    public GraphQLWSSubprotocolHandler(GraphQLWebSocketSession session, Map<String, Object> context) {
        super(session, MessageType.GQL_DATA.asString(), context);
    }

    @Deprecated
    public GraphQLWSSubprotocolHandler(GraphQLWebSocketSession session, ExecutionService executionService) {
        this(session, Collections.emptyMap());
    }

    @Override
    protected void onMessage(JsonObject message) {
        if (message != null) {
            MessageType messageType = this.getMessageType(message);
            try {
                switch (messageType) {
                    case GQL_CONNECTION_INIT: {
                        this.sendConnectionAckMessage();
                        break;
                    }
                    case GQL_START: {
                        this.sendDataMessage(message);
                        break;
                    }
                    case GQL_STOP: {
                        this.sendCancelMessage(message);
                    }
                }
            }
            catch (IOException e) {
                this.LOG.warn((Object)e);
            }
        }
    }

    private MessageType getMessageType(JsonObject message) {
        return MessageType.fromString(message.getString("type"));
    }

    @Override
    protected void closeDueToConnectionNotInitialized() {
        this.session.close((short)4429, "Connection not initialized");
    }

    @Override
    protected String getPingMessage() {
        return this.pingMessage;
    }

    @Override
    protected void sendErrorMessage(String operationId, ExecutionResponse executionResponse) throws IOException {
        this.session.sendMessage(this.createErrorMessage(operationId, ((JsonValue)executionResponse.getExecutionResultAsJsonObject().getJsonArray("errors").get(0)).asJsonObject()).toString());
    }

    private JsonObject createErrorMessage(String operationId, JsonObject error) {
        return Json.createObjectBuilder().add("id", operationId).add("type", MessageType.GQL_ERROR.asString()).add("payload", (JsonValue)error).build();
    }

    private JsonObject createPingMessage() {
        return Json.createObjectBuilder().add("type", MessageType.GQL_CONNECTION_KEEP_ALIVE.asString()).build();
    }
}

